<?php if ( !defined( 'ABSPATH' ) ) exit();

	$portfolios = ova_por_query( $args );

	$template 	= $args['template'];
	$columns 	= $args['columns'];

	$show_category       = $args['show_category'];
	$show_text_count     = $args['show_text_count_gallery'];
	$text_count_gallery  = isset($args['text_count_gallery']) ? $args['text_count_gallery'] : '' ;

?>

<div class="portfolio-grid <?php echo esc_attr( $template ).' '.esc_attr( $columns ); ?>">

	<?php if ( $portfolios->have_posts() ): ?>

		<div class="wrapper">
			<?php $index = 0; while ( $portfolios->have_posts() ) : $portfolios->the_post();
				$id 		= get_the_ID();
				$image_src 	= \Elementor\Utils::get_placeholder_image_src();
				$image_alt 	= get_the_title();
				if ( has_post_thumbnail( $id ) ) {
					$image_src 	= get_the_post_thumbnail_url( $id, 'ova_por_thumbnail' );
					$image_id 	= get_post_thumbnail_id( $id );
					if (get_post_meta($image_id, '_wp_attachment_image_alt', true)) {
						$image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
					}
				}

				$gallery = get_post_meta( $id, 'ova_por_met_gallery', true );

				$index += 1;
				$class_lower = '';
				if ( $index % 2 == 0 ) {
					$class_lower = 'lower';
				}
				if ( $lower_column != 'yes' ) {
					$class_lower = '';
				}

				$categories = get_the_terms( $id, 'cat_por' );
				$cate_links = array();
				if ( $categories ) {
					foreach ($categories as $cate) {
						array_push( $cate_links, '<a href="'.esc_url( get_term_link( $cate ) ).'" title="'.esc_attr( get_the_title($id) ).'">'.esc_html( $cate->name ).'</a>' );
					}
				}
			?>

				<div class="item <?php echo esc_attr( $class_lower ); ?>">
					<div class="item-wrap">
						<img src="<?php echo esc_url( $image_src ); ?>" alt="<?php echo esc_attr( $image_alt ); ?>" class="img">
						<div class="info">
							<div class="info-wrap">
								<?php if ( $show_icon == 'yes' ) : ?>
		        					<?php if ( $show_link_to == 'yes' ) : ?>
		        					<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">	
									<?php endif; ?>
										<div class="icon">
											<i class="gimonticon gimonticon-right" aria-hidden="true"></i>
										</div>
									<?php if ( $show_link_to == 'yes' ) : ?>
									</a>
									<?php endif; ?>
								<?php else: ?>
									<div class="empty-icon"></div>
								<?php endif; ?>

								<div class="content">
									<?php if ( !empty( $gallery ) && $show_text_count == 'yes' ) { ?>
										<span class="number-gallery">
											<?php echo count( $gallery ) . $text_count_gallery; ?>
										</span>
									<?php } ?>
									<?php if ( $cate_links && $show_category == 'yes' ): ?>
										<p class="categories"><?php echo implode(", ",$cate_links); ?></p>
									<?php endif; ?>

									<?php if ( $show_title == 'yes' ) : ?>
										<?php if ( $show_link_to == 'yes' ) : ?>
										<a href="<?php the_permalink(); ?>"
											title="<?php the_title(); ?>"
										>
										<?php endif; ?>
				        					<h3 class="title">
												<?php echo esc_html( get_the_title() ); ?>
											</h3>
										<?php if ( $show_link_to == 'yes' ) : ?>
										</a>
										<?php endif; ?>
									<?php endif; ?>
								</div>
							</div>
						</div>
					</div>
				</div>

			<?php endwhile; ?>

		</div>

	<?php endif;wp_reset_postdata(); ?>

</div>