<?php

namespace ova_sev_elementor;

use ova_sev_elementor\widgets\ova_sev_category;
use ova_sev_elementor\widgets\ova_sev_category_2;
use ova_sev_elementor\widgets\ova_sev_items;
use ova_sev_elementor\widgets\ova_sev_list;
use ova_sev_elementor\widgets\ova_sev_list_2;
use ova_sev_elementor\widgets\ova_sev_list_box;
use ova_sev_elementor\widgets\ova_sev_list_box_2;
use ova_sev_elementor\widgets\ova_sev_icon_box;
use ova_sev_elementor\widgets\ova_sev_info;
use ova_sev_elementor\widgets\ova_sev_table_of_contents;
use ova_sev_elementor\widgets\ova_sev_search_ajax;
use ova_sev_elementor\widgets\ova_service_ajax;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


/**
 * Main Plugin Class
 *
 * Register new elementor widget.
 *
 * @since 1.0.0
 */
class Ova_Sev_Register_Elementor {

	/**
	 * Constructor
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function __construct() {
		$this->add_actions();
	}

	/**
	 * Add Actions
	 *
	 * @since 1.0.0
	 *
	 * @access private
	 */
	private function add_actions() {

	     // Register Ovatheme Category in Pane
	    add_action( 'elementor/elements/categories_registered', array( $this, 'add_ovatheme_service_category' ) );
	    
		
		add_action( 'elementor/widgets/register', [ $this, 'on_widgets_registered' ] );
		

	}

	
	public function add_ovatheme_service_category(  ) {

	    \Elementor\Plugin::instance()->elements_manager->add_category(
	        'ovatheme_service',
	        [
	            'title' => __( 'Ovatheme Service', 'ova-sev' ),
	            'icon' => 'fa fa-plug',
	        ]
	    );

	}


	/**
	 * On Widgets Registered
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function on_widgets_registered() {
		$this->includes();
		$this->register_widget();
	}

	/**
	 * Includes
	 *
	 * @since 1.0.0
	 *
	 * @access private
	 */
	private function includes() {
		require OVASEV_PLUGIN_PATH . 'elementor/widgets/ova_sev_category.php';
		require OVASEV_PLUGIN_PATH . 'elementor/widgets/ova_sev_category_2.php';
		require OVASEV_PLUGIN_PATH . 'elementor/widgets/ova_sev_items.php';
		require OVASEV_PLUGIN_PATH . 'elementor/widgets/ova_sev_list.php';
		require OVASEV_PLUGIN_PATH . 'elementor/widgets/ova_sev_list_2.php';
		require OVASEV_PLUGIN_PATH . 'elementor/widgets/ova_sev_list_box.php';
		require OVASEV_PLUGIN_PATH . 'elementor/widgets/ova_sev_list_box_2.php';
		require OVASEV_PLUGIN_PATH . 'elementor/widgets/ova_sev_icon_box.php';
		require OVASEV_PLUGIN_PATH . 'elementor/widgets/ova_sev_info.php';
		require OVASEV_PLUGIN_PATH . 'elementor/widgets/ova_sev_table_of_contents.php';
		require OVASEV_PLUGIN_PATH . 'elementor/widgets/ova_sev_search_ajax.php';
		require OVASEV_PLUGIN_PATH . 'elementor/widgets/ova_service_ajax.php';
	}

	/**
	 * Register Widget
	 *
	 * @since 1.0.0
	 *
	 * @access private
	 */
	private function register_widget() {

		\Elementor\Plugin::instance()->widgets_manager->register( new ova_sev_category() );
		\Elementor\Plugin::instance()->widgets_manager->register( new ova_sev_category_2() );
		\Elementor\Plugin::instance()->widgets_manager->register( new ova_sev_items() );
		\Elementor\Plugin::instance()->widgets_manager->register( new ova_sev_list() );
		\Elementor\Plugin::instance()->widgets_manager->register( new ova_sev_list_2() );
		\Elementor\Plugin::instance()->widgets_manager->register( new ova_sev_list_box() );
		\Elementor\Plugin::instance()->widgets_manager->register( new ova_sev_list_box_2() );
		\Elementor\Plugin::instance()->widgets_manager->register( new ova_sev_icon_box() );
		\Elementor\Plugin::instance()->widgets_manager->register( new ova_sev_info() );
		\Elementor\Plugin::instance()->widgets_manager->register( new ova_sev_table_of_contents() );
		\Elementor\Plugin::instance()->widgets_manager->register( new ova_sev_search_ajax() );
		\Elementor\Plugin::instance()->widgets_manager->register( new ova_service_ajax() );

	}
	    
	

}

new Ova_Sev_Register_Elementor();