<?php

if (!defined( 'ABSPATH' )) {
	exit;
}
if (!class_exists( 'Ova_Sev_Customize' )){

	class Ova_Sev_Customize {

		public function __construct() {
			add_action( 'customize_register', array( $this, 'ova_sev_customize_register' ) );
		}

		public function ova_sev_customize_register($wp_customize) {

			$this->ova_sev_init( $wp_customize );

			do_action( 'ova_sev_customize_register', $wp_customize );
		}


		public function ova_sev_init( $wp_customize ){

			$wp_customize->add_panel( 'ova_sev_panel', array(
			  	'title' => esc_html__( 'Service', 'ova-sev' ),
			  	'priority' => 5,
			) );

			$wp_customize->add_section( 'ova_sev_archive_section' , array(
				'title'      => esc_html__( 'Archive', 'ova-sev' ),
				'priority'   => 1,
				'panel' => 'ova_sev_panel',
			) );

			$wp_customize->add_section( 'ova_sev_single_section' , array(
				'title'      => esc_html__( 'Single', 'ova-sev' ),
				'priority'   => 2,
				'panel' => 'ova_sev_panel',
			) );

			// Archive
			$wp_customize->add_setting( 'ova_sev_total_record', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => '9',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_sev_total_record', array(
				'label' => esc_html__('Number of posts per page','ova-sev'),
				'section' => 'ova_sev_archive_section',
				'settings' => 'ova_sev_total_record',
				'type' =>'number'
			));

			$wp_customize->add_setting( 'ova_sev_orderby', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'ID',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('ova_sev_orderby', array(
				'label' 	=> esc_html__('Order By','ova-sev'),
				'section' 	=> 'ova_sev_archive_section',
				'settings' 	=> 'ova_sev_orderby',
				'type' 		=>'select',
				'choices' 	=> array(
					'ova_sev_met_order_sev' 	=> esc_html__( 'Sort Order', 'ova-sev' ),
					'ID' 						=> esc_html__( 'ID', 'ova-sev' ),
					'title' 					=> esc_html__( 'Title', 'ova-sev' ),
					'date' 						=> esc_html__( 'Date', 'ova-sev' ),
					'rand' 						=> esc_html__( 'Random', 'ova-sev' ),
				)
			));

			$wp_customize->add_setting( 'ova_sev_order', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'DESC',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('ova_sev_order', array(
				'label' 	=> esc_html__('Order','ova-sev'),
				'section' 	=> 'ova_sev_archive_section',
				'settings' 	=> 'ova_sev_order',
				'type' 		=>'select',
				'choices' 	=> array(
					'ASC' 	=> esc_html__( 'Ascending', 'ova-sev' ),
					'DESC' 	=> esc_html__( 'Descending', 'ova-sev' ),
				)
			));

			$wp_customize->add_setting( 'ova_sev_layout', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'three_columns',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_sev_layout', array(
				'label' => esc_html__('Layout','ova-sev'),
				'section' => 'ova_sev_archive_section',
				'settings' => 'ova_sev_layout',
				'type' =>'select',
				'choices' => array(
					'two_columns' 		=> esc_html__( '2 column', 'ova-sev' ),
					'three_columns' 	=> esc_html__( '3 column', 'ova-sev' ),
					'four_columns' 		=> esc_html__( '4 column', 'ova-sev' ),
				)
			));

			$wp_customize->add_setting( 'header_archive_sev', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'default',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('header_archive_sev', array(
				'label' => esc_html__('Header','ova-sev'),
				'section' => 'ova_sev_archive_section',
				'settings' => 'header_archive_sev',
				'type' =>'select',
				'choices' => apply_filters('gimont_list_header', '')
			));

			$wp_customize->add_setting( 'archive_footer_sev', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'default',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('archive_footer_sev', array(
				'label' => esc_html__('Footer','ova-sev'),
				'section' => 'ova_sev_archive_section',
				'settings' => 'archive_footer_sev',
				'type' =>'select',
				'choices' => apply_filters('gimont_list_footer', '')
			));

			$wp_customize->add_setting( 'ova_sev_show_search_name', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'yes',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('ova_sev_show_search_name', array(
				'label' 	=> esc_html__('Show Search by Name','ova-sev'),
				'section' 	=> 'ova_sev_archive_section',
				'settings' 	=> 'ova_sev_show_search_name',
				'type' 		=>'select',
				'choices' 	=> array(
					'yes' 	=> esc_html__( 'Yes', 'ova-sev' ),
					'no' 	=> esc_html__( 'No', 'ova-sev' ),
				)
			));

			$wp_customize->add_setting( 'ova_sev_show_search_category', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'yes',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('ova_sev_show_search_category', array(
				'label' 	=> esc_html__('Show Search by Category','ova-sev'),
				'section' 	=> 'ova_sev_archive_section',
				'settings' 	=> 'ova_sev_show_search_category',
				'type' 		=>'select',
				'choices' 	=> array(
					'yes' 	=> esc_html__( 'Yes', 'ova-sev' ),
					'no' 	=> esc_html__( 'No', 'ova-sev' ),
				)
			));

			$wp_customize->add_setting( 'ova_sev_show_total_results', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'yes',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('ova_sev_show_total_results', array(
				'label' 	=> esc_html__('Show Total results','ova-sev'),
				'section' 	=> 'ova_sev_archive_section',
				'settings' 	=> 'ova_sev_show_total_results',
				'type' 		=>'select',
				'choices' 	=> array(
					'yes' 	=> esc_html__( 'Yes', 'ova-sev' ),
					'no' 	=> esc_html__( 'No', 'ova-sev' ),
				)
			));

			$wp_customize->add_setting( 'ova_sev_show_sort_by', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'yes',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('ova_sev_show_sort_by', array(
				'label' 	=> esc_html__('Show Sort by','ova-sev'),
				'section' 	=> 'ova_sev_archive_section',
				'settings' 	=> 'ova_sev_show_sort_by',
				'type' 		=>'select',
				'choices' 	=> array(
					'yes' 	=> esc_html__( 'Yes', 'ova-sev' ),
					'no' 	=> esc_html__( 'No', 'ova-sev' ),
				)
			));

			$wp_customize->add_setting( 'ova_sev_archive_show_icon', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'yes',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('ova_sev_archive_show_icon', array(
				'label' 	=> esc_html__('Show Icon','ova-sev'),
				'section' 	=> 'ova_sev_archive_section',
				'settings' 	=> 'ova_sev_archive_show_icon',
				'type' 		=>'select',
				'choices' 	=> array(
					'yes' 	=> esc_html__( 'Yes', 'ova-sev' ),
					'no' 	=> esc_html__( 'No', 'ova-sev' ),
				)
			));

			$wp_customize->add_setting( 'ova_sev_archive_show_title', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'yes',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('ova_sev_archive_show_title', array(
				'label' 	=> esc_html__('Show Title','ova-sev'),
				'section' 	=> 'ova_sev_archive_section',
				'settings' 	=> 'ova_sev_archive_show_title',
				'type' 		=>'select',
				'choices' 	=> array(
					'yes' 	=> esc_html__( 'Yes', 'ova-sev' ),
					'no' 	=> esc_html__( 'No', 'ova-sev' ),
				)
			));

			$wp_customize->add_setting( 'ova_sev_archive_show_link_of_title', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'yes',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('ova_sev_archive_show_link_of_title', array(
				'label' 	=> esc_html__('Show Link of Title','ova-sev'),
				'section' 	=> 'ova_sev_archive_section',
				'settings' 	=> 'ova_sev_archive_show_link_of_title',
				'type' 		=>'select',
				'choices' 	=> array(
					'yes' 	=> esc_html__( 'Yes', 'ova-sev' ),
					'no' 	=> esc_html__( 'No', 'ova-sev' ),
				)
			));

			$wp_customize->add_setting( 'ova_sev_archive_show_excerpt', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'yes',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('ova_sev_archive_show_excerpt', array(
				'label' 	=> esc_html__('Show Short Description','ova-sev'),
				'section' 	=> 'ova_sev_archive_section',
				'settings' 	=> 'ova_sev_archive_show_excerpt',
				'type' 		=>'select',
				'choices' 	=> array(
					'yes' 	=> esc_html__( 'Yes', 'ova-sev' ),
					'no' 	=> esc_html__( 'No', 'ova-sev' ),
				)
			));

			$wp_customize->add_setting( 'ova_sev_archive_show_button', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'yes',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('ova_sev_archive_show_button', array(
				'label' 	=> esc_html__('Show Button','ova-sev'),
				'section' 	=> 'ova_sev_archive_section',
				'settings' 	=> 'ova_sev_archive_show_button',
				'type' 		=>'select',
				'choices' 	=> array(
					'yes' 	=> esc_html__( 'Yes', 'ova-sev' ),
					'no' 	=> esc_html__( 'No', 'ova-sev' ),
				)
			));

			// Single
			$wp_customize->add_setting( 'ova_sev_single_template', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'template_1',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_sev_single_template', array(
				'label' => esc_html__('Template','ova-sev'),
				'section' => 'ova_sev_single_section',
				'settings' => 'ova_sev_single_template',
				'type' =>'select',
				'choices' => array(
					'template_1' => esc_html__( 'Template 1', 'ova-sev' ),
					'template_2' => esc_html__( 'Template 2', 'ova-sev' ),
				)
			));

			$wp_customize->add_setting( 'ova_sev_sidebar', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'left_sidebar',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_sev_sidebar', array(
				'label' => esc_html__('Sidebar','ova-sev'),
				'section' => 'ova_sev_single_section',
				'settings' => 'ova_sev_sidebar',
				'type' =>'select',
				'choices' => array(
					'left_sidebar'    => esc_html__( 'Left Sidebar', 'ova-sev' ),
					'right_sidebar'   => esc_html__( 'Right Sidebar', 'ova-sev' ),
					'no_sidebar'      => esc_html__( 'No Sidebar', 'ova-sev' ),
				),
				'active_callback' => array( $this, 'is_service_single_template_1' ),
			));

			$wp_customize->add_setting( 'header_single_sev', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'default',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name  
			) );

			$wp_customize->add_control('header_single_sev', array(
				'label' => esc_html__('Header','ova-sev'),
				'section' => 'ova_sev_single_section',
				'settings' => 'header_single_sev',
				'type' =>'select',
				'choices' => apply_filters('gimont_list_header', ''),
				'active_callback' => array( $this, 'is_service_single_template_1' ),
			));

			$wp_customize->add_setting( 'single_footer_sev', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'default',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('single_footer_sev', array(
				'label' => esc_html__('Footer','ova-sev'),
				'section' => 'ova_sev_single_section',
				'settings' => 'single_footer_sev',
				'type' =>'select',
				'choices' => apply_filters('gimont_list_footer', ''),
				'active_callback' => array( $this, 'is_service_single_template_1' ),
			));

			// Single Service 2
			$wp_customize->add_setting( 'ova_sev_sidebar_2', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'no_sidebar',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_sev_sidebar_2', array(
				'label' => esc_html__('Sidebar Template 2','ova-sev'),
				'section' => 'ova_sev_single_section',
				'settings' => 'ova_sev_sidebar_2',
				'type' =>'select',
				'choices' => array(
					'left_sidebar'    => esc_html__( 'Left Sidebar', 'ova-sev' ),
					'right_sidebar'   => esc_html__( 'Right Sidebar', 'ova-sev' ),
					'no_sidebar'      => esc_html__( 'No Sidebar', 'ova-sev' ),
				),
				'active_callback' => array( $this, 'is_service_single_template_2' ),
			));

			$wp_customize->add_setting( 'header_single_sev_2', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'default',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name  
			) );
			$wp_customize->add_control('header_single_sev_2', array(
				'label' => esc_html__('Header Template 2','ova-sev'),
				'section' => 'ova_sev_single_section',
				'settings' => 'header_single_sev_2',
				'type' =>'select',
				'choices' => apply_filters('gimont_list_header', ''),
				'active_callback' => array( $this, 'is_service_single_template_2' ),
			));

			$wp_customize->add_setting( 'single_footer_sev_2', array(
			  'type' => 'theme_mod', // or 'option'
			  'capability' => 'edit_theme_options',
			  'theme_supports' => '', // Rarely needed.
			  'default' => 'default',
			  'transport' => 'refresh', // or postMessage
			  'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );
			$wp_customize->add_control('single_footer_sev_2', array(
				'label' => esc_html__('Footer Template 2','ova-sev'),
				'section' => 'ova_sev_single_section',
				'settings' => 'single_footer_sev_2',
				'type' =>'select',
				'choices' => apply_filters('gimont_list_footer', ''),
				'active_callback' => array( $this, 'is_service_single_template_2' ),
			));

			// show fields
			$wp_customize->add_setting( 'ova_sev_single_show_featured_image', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'yes',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));
			$wp_customize->add_control('ova_sev_single_show_featured_image', array(
				'label' 	=> esc_html__('Show Featured Image','ova-sev'),
				'section' 	=> 'ova_sev_single_section',
				'settings' 	=> 'ova_sev_single_show_featured_image',
				'type' 		=>'select',
				'choices' 	=> array(
					'yes' 	=> esc_html__( 'Yes', 'ova-sev' ),
					'no' 	=> esc_html__( 'No', 'ova-sev' ),
				)
			));

			$wp_customize->add_setting( 'ova_sev_single_show_title', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'yes',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));
			$wp_customize->add_control('ova_sev_single_show_title', array(
				'label' 	=> esc_html__('Show Title','ova-sev'),
				'section' 	=> 'ova_sev_single_section',
				'settings' 	=> 'ova_sev_single_show_title',
				'type' 		=>'select',
				'choices' 	=> array(
					'yes' 	=> esc_html__( 'Yes', 'ova-sev' ),
					'no' 	=> esc_html__( 'No', 'ova-sev' ),
				)
			));

			$wp_customize->add_setting( 'ova_sev_single_show_excerpt', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'yes',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));
			$wp_customize->add_control('ova_sev_single_show_excerpt', array(
				'label' 	=> esc_html__('Show Excerpt','ova-sev'),
				'section' 	=> 'ova_sev_single_section',
				'settings' 	=> 'ova_sev_single_show_excerpt',
				'type' 		=>'select',
				'choices' 	=> array(
					'yes' 	=> esc_html__( 'Yes', 'ova-sev' ),
					'no' 	=> esc_html__( 'No', 'ova-sev' ),
				),
			));

			$wp_customize->add_setting( 'ova_sev_single_show_content', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'yes',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));
			$wp_customize->add_control('ova_sev_single_show_content', array(
				'label' 	=> esc_html__('Show Content','ova-sev'),
				'section' 	=> 'ova_sev_single_section',
				'settings' 	=> 'ova_sev_single_show_content',
				'type' 		=>'select',
				'choices' 	=> array(
					'yes' 	=> esc_html__( 'Yes', 'ova-sev' ),
					'no' 	=> esc_html__( 'No', 'ova-sev' ),
				)
			));

			$wp_customize->add_setting( 'ova_sev_single_show_share', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'yes',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));
			$wp_customize->add_control('ova_sev_single_show_share', array(
				'label' 	=> esc_html__('Show Share Social','ova-sev'),
				'section' 	=> 'ova_sev_single_section',
				'settings' 	=> 'ova_sev_single_show_share',
				'type' 		=>'select',
				'choices' 	=> array(
					'yes' 	=> esc_html__( 'Yes', 'ova-sev' ),
					'no' 	=> esc_html__( 'No', 'ova-sev' ),
				)
			));

			$wp_customize->add_setting( 'ova_sev_comments', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );
			$wp_customize->add_control('ova_sev_comments', array(
				'label' => esc_html__('Show Comments','ova-sev'),
				'section' => 'ova_sev_single_section',
				'settings' => 'ova_sev_comments',
				'type' =>'select',
				'choices' => array(
					'yes'	=> esc_html__( 'Yes', 'ova-sev' ),
					'no'	=> esc_html__( 'No', 'ova-sev' ),
				)
			));

		}

		// Define the callback function
		public function is_service_single_template_1() {
		    return get_theme_mod( 'ova_sev_single_template', 'template_1' ) === 'template_1';
		}

		public function is_service_single_template_2() {
		    return get_theme_mod( 'ova_sev_single_template', 'template_1' ) === 'template_2';
		}

	}

}

new Ova_Sev_Customize();