<?php

namespace ova_team_elementor;

use ova_team_elementor\widgets\ova_team_slider;
use ova_team_elementor\widgets\ova_team_grid;
use ova_team_elementor\widgets\ova_team_grid_2;
use ova_team_elementor\widgets\ova_team_grid_3;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Main Plugin Class
 *
 * Register new elementor widget.
 *
 * @since 1.0.0
 */
class Ova_Team_Register_Elementor {

	/**
	 * Constructor
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function __construct() {
		$this->add_actions();
	}

	/**
	 * Add Actions
	 *
	 * @since 1.0.0
	 *
	 * @access private
	 */
	private function add_actions() {

	    // Register Ovatheme Category in Pane
	    add_action( 'elementor/elements/categories_registered', array( $this, 'add_ovatheme_team_category' ) );

		add_action( 'elementor/widgets/register', [ $this, 'on_widgets_registered' ] );

	}

	
	public function add_ovatheme_team_category(  ) {

	    \Elementor\Plugin::instance()->elements_manager->add_category(
	        'ovatheme_team',
	        [
	            'title' => __( 'Ovatheme Team', 'ova-team' ),
	            'icon' => 'fa fa-plug',
	        ]
	    );

	}


	/**
	 * On Widgets Registered
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function on_widgets_registered($widgets_manager) {
		$this->includes();
		$this->register_widget( $widgets_manager );
	}

	/**
	 * Includes
	 *
	 * @since 1.0.0
	 *
	 * @access private
	 */
	private function includes() {

		require OVATEAM_PLUGIN_PATH . 'elementor/widgets/ova_team_slider.php';
		require OVATEAM_PLUGIN_PATH . 'elementor/widgets/ova_team_grid.php';
		require OVATEAM_PLUGIN_PATH . 'elementor/widgets/ova_team_grid_2.php';
		require OVATEAM_PLUGIN_PATH . 'elementor/widgets/ova_team_grid_3.php';
	}

	/**
	 * Register Widget
	 *
	 * @since 1.0.0
	 *
	 * @access private
	 */
	private function register_widget($widgets_manager) {

		$widgets_manager->register( new ova_team_slider() );
		$widgets_manager->register( new ova_team_grid() );
		$widgets_manager->register( new ova_team_grid_2() );
		$widgets_manager->register( new ova_team_grid_3() );
	}
}

new Ova_Team_Register_Elementor();