<?php
namespace ova_team_elementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class ova_team_grid_3 extends Widget_Base {


	public function get_name() {
		return 'ova_team_grid_3';
	}

	public function get_title() {
		return esc_html__( 'Our Team Grid 3', 'ova-team' );
	}

	public function get_icon() {
		return 'eicon-posts-grid';
	}

	public function get_categories() {
		return [ 'ovatheme_team' ];
	}

	public function get_script_depends() {
		return [ '' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'ovateam_general', OVATEAM_PLUGIN_URI.'assets/css/frontend/ovateam-general.css' );
		wp_enqueue_style( 'ova-team-grid-3', OVATEAM_PLUGIN_URI.'assets/css/elementor/our-team-grid-3.css' );
		return [];
	}

	protected function register_controls() {

		/* Content */
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'ova-team' ),
			]
		);

			$this->add_control(
				'template',
				[
					'label' => esc_html__( 'Template', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'template_1',
					'options' => [
						'template_1' => esc_html__( 'Template 1', 'ova-team' ),
						'template_2' => esc_html__( 'Template 2', 'ova-team' ),
					],
				]
			);

			$this->add_control(
				'columns',
				[
					'label' => esc_html__( 'Columns', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'four_column',
					'options' => [
						'two_column' => esc_html__( '2 Columns', 'ova-team' ),
						'three_column' => esc_html__( '3 Columns', 'ova-team' ),
						'four_column' => esc_html__( '4 Columns', 'ova-team' ),
					],
				]
			);

			$args = array(
	           'taxonomy' => 'cat_team',
	           'orderby' => 'name',
	           'order'   => 'ASC'
	       	);
		
			$categories = get_categories($args);
			$cate_array = array( 'all' => esc_html__('All categories', 'ova-team' ) );
			if ($categories) {
				foreach ( $categories as $cate ) {
					$cate_array[$cate->slug] = $cate->cat_name;
				}
			}
			$this->add_control(
				'category',
				[
					'label'   => esc_html__( 'Category', 'ova-team' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'all',
					'options' => $cate_array,
				]
			);

			$this->add_control(
				'total_count',
				[
					'label'   => esc_html__( 'Total', 'ova-team' ),
					'type'    => Controls_Manager::NUMBER,
					'default' => 4
				]
			);

			$this->add_control(
				'orderby_post',
				[
					'label' => __( 'OrderBy Post', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'ID',
					'options' => [
						'ID'  	=> esc_html__( 'ID', 'ova-team' ),
						'date'  => esc_html__( 'Date', 'ova-team' ),
						'title' => esc_html__( 'Title', 'ova-team' ),
						'rand'  => esc_html__( 'Random', 'ova-team' ),
						'ova_team_met_order_team' => esc_html__( 'Custom Order', 'ova-team' ),
					],
				]
			);

			$this->add_control(
				'order_post',
				[
					'label' => esc_html__( 'Order', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'DESC',
					'options' => [
						'ASC'  	=> esc_html__( 'Ascending', 'ova-team' ),
						'DESC'  => esc_html__( 'Descending', 'ova-team' ),
					],
				]
			);

			$this->add_control(
				'show_image',
				[
					'label' => esc_html__( 'Show Image', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-team' ),
					'label_off' => esc_html__( 'Hide', 'ova-team' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_name',
				[
					'label' => esc_html__( 'Show Name', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-team' ),
					'label_off' => esc_html__( 'Hide', 'ova-team' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_job',
				[
					'label' => esc_html__( 'Show Job', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-team' ),
					'label_off' => esc_html__( 'Hide', 'ova-team' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_social',
				[
					'label' => esc_html__( 'Show Social', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-team' ),
					'label_off' => esc_html__( 'Hide', 'ova-team' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_link_to',
				[
					'label' => esc_html__( 'Show Link to Detail', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-team' ),
					'label_off' => esc_html__( 'Hide', 'ova-team' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

		$this->end_controls_section();

		/* Items */
		$this->start_controls_section(
				'style_section',
				[
					'label' => esc_html__( 'Items', 'ova-team' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'item_pad',
				[
					'label' => esc_html__( 'Padding', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .archive_team_3 .items' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'item_bg',
				[
					'label' => esc_html__( 'Background', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .archive_team_3 .items' => 'background: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'item_box_shadow',
					'selector' => '{{WRAPPER}} .archive_team_3 .items',
				]
			);

		$this->end_controls_section();

		/* Socials */
		$this->start_controls_section(
				'socials_style_section',
				[
					'label' => esc_html__( 'Socials', 'ova-team' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'socials_pad',
				[
					'label' => esc_html__( 'Padding', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .archive_team_3 .ova-social' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'socials_bg',
				[
					'label' => esc_html__( 'Background', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .archive_team_3 .ova-social' => 'background: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'socials_color',
				[
					'label' => esc_html__( 'Color', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .archive_team_3 .ova-social a' => 'color: {{VALUE}}',
						'{{WRAPPER}} .archive_team_3 .ova-social a i' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Name */
		$this->start_controls_section(
				'name_style_section',
				[
					'label' => esc_html__( 'Name', 'ova-team' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'name_mg',
				[
					'label' => esc_html__( 'Margin', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .archive_team_3 .name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'name_typography',
					'selector' => '{{WRAPPER}} .archive_team_3 .name a',
				]
			);


			$this->start_controls_tabs(
					'name_style_tabs'
				);

				$this->start_controls_tab(
					'name_style_normal_tab',
					[
						'label' => esc_html__( 'Normal', 'ova-team' ),
					]
				);

					$this->add_control(
						'name_color',
						[
							'label' => esc_html__( 'Color', 'ova-team' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .archive_team_3 .name a' => 'color: {{VALUE}}',
							],
						]
					);

				$this->end_controls_tab();

				$this->start_controls_tab(
					'name_style_hover_tab',
					[
						'label' => esc_html__( 'Hover', 'ova-team' ),
					]
				);

					$this->add_control(
						'name_hv_color',
						[
							'label' => esc_html__( 'Color', 'ova-team' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .archive_team_3 .name a:hover' => 'color: {{VALUE}}',
							],
						]
					);

				$this->end_controls_tab();

			$this->end_controls_tabs();

		$this->end_controls_section();

		/* Job */
		$this->start_controls_section(
				'job_style_section',
				[
					'label' => esc_html__( 'Job', 'ova-team' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'job_mg',
				[
					'label' => esc_html__( 'Margin', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .archive_team_3 .job' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'job_typography',
					'selector' => '{{WRAPPER}} .archive_team_3 .job',
				]
			);

			$this->add_control(
				'job_color',
				[
					'label' => esc_html__( 'Color', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .archive_team_3 .job' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();
	}

	protected function render() {

		$settings = $this->get_settings();

		$template = apply_filters( 'el_elementor_ova_team_grid_3', 'elementor/ova_team_grid_3.php' );

		ob_start();
		ovateam_get_template( $template, $settings );
		echo ob_get_clean();
		
	}
}
