<?php
namespace ova_team_elementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class ova_team_slider extends Widget_Base {


	public function get_name() {
		return 'ova_team_slider';
	}

	public function get_title() {
		return esc_html__( 'Our Team Slide', 'ova-team' );
	}

	public function get_icon() {
		return 'eicon-post-slider';
	}

	public function get_categories() {
		return [ 'ovatheme_team' ];
	}

	public function get_script_depends() {
		wp_enqueue_style( 'carousel', OVATEAM_PLUGIN_URI.'assets/libs/owl-carousel/assets/owl.carousel.min.css' );
		wp_enqueue_script( 'carousel', OVATEAM_PLUGIN_URI.'assets/libs/owl-carousel/owl.carousel.min.js', array('jquery'), false, true );
		wp_enqueue_script( 'script-elementor-team' );
		return [ '' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'ova-team-grid', OVATEAM_PLUGIN_URI.'assets/css/elementor/our-team-grid.css' );
		wp_enqueue_style( 'ova-team-grid-2', OVATEAM_PLUGIN_URI.'assets/css/elementor/our-team-grid-2.css' );
		wp_enqueue_style( 'ova-team-grid-3', OVATEAM_PLUGIN_URI.'assets/css/elementor/our-team-grid-3.css' );
		wp_enqueue_style( 'ova-team-slider', OVATEAM_PLUGIN_URI.'assets/css/elementor/our-team-slider.css' );
		return [];
	}

	protected function register_controls() {
		/* Content */
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'ova-team' ),
			]
		);

			$this->add_control(
				'template',
				[
					'label' => esc_html__( 'Template', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'grid_default',
					'options' => [
						'grid_default' 	=> esc_html__( 'Grid Default', 'ova-team' ),
						'grid_modern' 	=> esc_html__( 'Grid Modern', 'ova-team' ),
						'grid_modern_2' => esc_html__( 'Grid Modern 2', 'ova-team' ),
						'grid2_template_1'  => esc_html__( 'Grid 2 - Template 1', 'ova-team' ),
						'grid2_template_2'  => esc_html__( 'Grid 2 - Template 2', 'ova-team' ),
						'grid3_template_1'  => esc_html__( 'Grid 3 - Template 1', 'ova-team' ),
						'grid3_template_2'  => esc_html__( 'Grid 3 - Template 2', 'ova-team' ),
					],
				]
			);

			$args = array(
	           'taxonomy' => 'cat_team',
	           'orderby' => 'name',
	           'order'   => 'ASC'
	       	);
		
			$categories = get_categories($args);
			$cate_array = array( 'all' => esc_html__('All categories', 'ova-team' ) );
			if ($categories) {
				foreach ( $categories as $cate ) {
					$cate_array[$cate->slug] = $cate->cat_name;
				}
			}
			$this->add_control(
				'category',
				[
					'label'   => esc_html__( 'Category', 'ova-team' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'all',
					'options' => $cate_array
				]
			);

			$this->add_control(
				'total_count',
				[
					'label'   => esc_html__( 'Total', 'ova-team' ),
					'type'    => Controls_Manager::NUMBER,
					'default' => 6
				]
			);

			$this->add_control(
				'orderby_post',
				[
					'label' => esc_html__( 'OrderBy Post', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'ID',
					'options' => [
						'ID'  	=> esc_html__( 'ID', 'ova-team' ),
						'date'  => esc_html__( 'Date', 'ova-team' ),
						'title' => esc_html__( 'Title', 'ova-team' ),
						'rand'  => esc_html__( 'Random', 'ova-team' ),
						'ova_team_met_order_team' => esc_html__( 'Custom Order', 'ova-team' ),
					],
				]
			);

			$this->add_control(
				'order_post',
				[
					'label' => esc_html__( 'Order', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'DESC',
					'options' => [
						'ASC'  	=> esc_html__( 'Ascending', 'ova-team' ),
						'DESC'  => esc_html__( 'Descending', 'ova-team' ),
					],
				]
			);

			$this->add_control(
				'show_image',
				[
					'label' => esc_html__( 'Show Image', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-team' ),
					'label_off' => esc_html__( 'Hide', 'ova-team' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_name',
				[
					'label' => esc_html__( 'Show Name', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-team' ),
					'label_off' => esc_html__( 'Hide', 'ova-team' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_job',
				[
					'label' => esc_html__( 'Show Job', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-team' ),
					'label_off' => esc_html__( 'Hide', 'ova-team' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_social',
				[
					'label' => esc_html__( 'Show Social', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-team' ),
					'label_off' => esc_html__( 'Hide', 'ova-team' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_link_to',
				[
					'label' => esc_html__( 'Show Link to Detail', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-team' ),
					'label_off' => esc_html__( 'Hide', 'ova-team' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

		$this->end_controls_section();

		/* Additional Options */
		$this->start_controls_section(
				'section_additional_options',
				[
					'label' => esc_html__( 'Additional Options', 'ova-team' ),
				]
			);

			$this->add_control(
				'margin_items',
				[
					'label'   => esc_html__( 'Space between 2 items', 'ova-team' ),
					'type'    => Controls_Manager::NUMBER,
					'default' => 30,
				]
				
			);

			$this->add_control(
				'item_number',
				[
					'label'       => esc_html__( 'Number of Items', 'ova-team' ),
					'type'        => Controls_Manager::NUMBER,
					'description' => esc_html__( 'Number of Items', 'ova-team' ),
					'default'     => 3,
				]
			);
	

			$this->add_control(
				'slides_to_scroll',
				[
					'label'       => esc_html__( 'Slides to Scroll', 'ova-team' ),
					'type'        => Controls_Manager::NUMBER,
					'description' => esc_html__( 'Set how many slides are scrolled per swipe.', 'ova-team' ),
					'default'     => 1,
				]
			);

			$this->add_control(
				'pause_on_hover',
				[
					'label'   => esc_html__( 'Pause on Hover', 'ova-team' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'ova-team' ),
						'no'  => esc_html__( 'No', 'ova-team' ),
					],
					'frontend_available' => true,
				]
			);


			$this->add_control(
				'infinite',
				[
					'label'   => esc_html__( 'Infinite Loop', 'ova-team' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'ova-team' ),
						'no'  => esc_html__( 'No', 'ova-team' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'autoplay',
				[
					'label'   => esc_html__( 'Autoplay', 'ova-team' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'ova-team' ),
						'no'  => esc_html__( 'No', 'ova-team' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'autoplay_speed',
				[
					'label'     => esc_html__( 'Autoplay Speed', 'ova-team' ),
					'type'      => Controls_Manager::NUMBER,
					'default'   => 3000,
					'step'      => 500,
					'condition' => [
						'autoplay' => 'yes',
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'smartspeed',
				[
					'label'   => esc_html__( 'Smart Speed', 'ova-team' ),
					'type'    => Controls_Manager::NUMBER,
					'default' => 500,
				]
			);

			$this->add_control(
				'dot_control',
				[
					'label'   => esc_html__( 'Show Dots', 'ova-team' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'no',
					'options' => [
						'yes' => esc_html__( 'Yes', 'ova-team' ),
						'no'  => esc_html__( 'No', 'ova-team' ),
					],
					'frontend_available' => true,
				]
			);

		$this->end_controls_section();

		/* Items */
		$this->start_controls_section(
				'item_style_section',
				[
					'label' => esc_html__( 'Items', 'ova-team' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'item_padding',
				[
					'label' => esc_html__( 'Padding', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-team-slider .items' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'item_border_width',
				[
					'label' => esc_html__( 'Border Width', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 10,
							'step' => 1,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ova-team-slider .items' => 'border-width: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'item_border_color',
				[
					'label' => esc_html__( 'Border Color', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-team-slider .items' => 'border-image-source: linear-gradient(to bottom, {{VALUE}}, rgba(0, 0, 0, 0));',
					],
				]
			);

			$this->add_control(
				'item_bg_color',
				[
					'label' => esc_html__( 'Background', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-team-slider .items' => 'background: {{VALUE}};',
					],
				]
			);

		$this->end_controls_section();

		/* Job */
		$this->start_controls_section(
				'job_style_section',
				[
					'label' => esc_html__( 'Job', 'ova-team' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'job_margin',
				[
					'label' => esc_html__( 'Margin', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-team-slider .job' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'job_padding',
				[
					'label' => esc_html__( 'Padding', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-team-slider .job' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'job_typography',
					'selector' => '{{WRAPPER}} .ova-team-slider .job',
				]
			);

			$this->add_control(
				'job_color',
				[
					'label' => esc_html__( 'Color', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-team-slider .job' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Name */
		$this->start_controls_section(
				'name_style_section',
				[
					'label' => esc_html__( 'Name', 'ova-team' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'name_margin',
				[
					'label' => esc_html__( 'Margin', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-team-slider .name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'name_padding',
				[
					'label' => esc_html__( 'Padding', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-team-slider .name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'name_typography',
					'selector' => '{{WRAPPER}} .ova-team-slider .name a',
				]
			);

			$this->start_controls_tabs(
					'name_style_tabs'
				);

				$this->start_controls_tab(
						'name_style_normal_tab',
						[
							'label' => esc_html__( 'Normal', 'ova-team' ),
						]
					);

					$this->add_control(
						'name_color',
						[
							'label' => esc_html__( 'Color', 'ova-team' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-team-slider .name a' => 'color: {{VALUE}}',
							],
						]
					);

				$this->end_controls_tab();

				$this->start_controls_tab(
						'name_style_hover_tab',
						[
							'label' => esc_html__( 'Hover', 'ova-team' ),
						]
					);

					$this->add_control(
						'name_hover_color',
						[
							'label' => esc_html__( 'Color', 'ova-team' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-team-slider .name a:hover' => 'color: {{VALUE}}',
								'{{WRAPPER}} .ova-team-slider .name a:after' => 'background: {{VALUE}}',
							],
						]
					);

				$this->end_controls_tab();

			$this->end_controls_tabs();

		$this->end_controls_section();

		/* Social Icons */
		$this->start_controls_section(
				'icon_style_section',
				[
					'label' => esc_html__( 'Social Icons', 'ova-team' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'icon_width',
				[
					'label' => esc_html__( 'Width', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 80,
							'step' => 5,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ova-team-slider .ova-social .icon' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'icon_size',
				[
					'label' => esc_html__( 'Size', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 50,
							'step' => 5,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ova-team-slider .ova-social i' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'icon_border_radius',
				[
					'label' => esc_html__( 'Border Radius', 'ova-team' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-team-slider .ova-social .icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->start_controls_tabs(
					'icon_style_tabs'
				);

				$this->start_controls_tab(
						'icon_style_normal_tab',
						[
							'label' => esc_html__( 'Normal', 'ova-team' ),
						]
					);

					$this->add_control(
						'icon_color',
						[
							'label' => esc_html__( 'Color', 'ova-team' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-team-slider .ova-social a' => 'color: {{VALUE}}',
							],
						]
					);

					$this->add_control(
						'icon_bg',
						[
							'label' => esc_html__( 'Background', 'ova-team' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-team-slider .ova-social a' => 'background: {{VALUE}}',
							],
						]
					);

				$this->end_controls_tab();

				$this->start_controls_tab(
						'icon_style_hover_tab',
						[
							'label' => esc_html__( 'Hover', 'ova-team' ),
						]
					);

					$this->add_control(
						'icon_hover_color',
						[
							'label' => esc_html__( 'Color', 'ova-team' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-team-slider .ova-social a:hover' => 'color: {{VALUE}}',
							],
						]
					);

					$this->add_control(
						'icon_bg_hover',
						[
							'label' => esc_html__( 'Background', 'ova-team' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-team-slider .ova-social a:hover' => 'background: {{VALUE}}',
							],
						]
					);

				$this->end_controls_tab();

			$this->end_controls_tabs();

		$this->end_controls_section();

	}


	protected function render() {

		$settings = $this->get_settings();

		$template = apply_filters( 'el_elementor_ova_team_slider', 'elementor/ova_team_slider.php' );

		ob_start();
		ovateam_get_template( $template, $settings );
		echo ob_get_clean();
		
	}
}
