<?php if ( !defined( 'ABSPATH' ) ) exit();

get_header( );

	global $post;

	$id = get_the_ID();

	$image_id 		= get_post_thumbnail_id();
	$image_alt 		= get_the_title();
	$image_title 	= get_the_title();
	$image_src 		= '';

	if ( $image_id ) {
		$image_alt 		= get_post_meta( $image_id, '_wp_attachment_image_alt', true ) ;
		$image_title 	= get_the_title( $image_id );
		$image_src 		= isset(wp_get_attachment_image_src( $image_id, 'large' )[0]) ? wp_get_attachment_image_src( $image_id, 'large' )[0] : '';
	}

	if( $image_src == '' ) {
		$image_src  = \Elementor\Utils::get_placeholder_image_src();
	}

	$job 		= get_post_meta( $id, 'ova_team_met_job', true );
	$slogan 	= get_post_meta( $id, 'ova_team_met_slogan', true );
	$short_desc = get_post_meta( $id, 'ova_team_met_short_desc', true );

	$slogan_field_type     = get_theme_mod('ova_team_slogan_field_type','textarea');
	$short_desc_field_type = get_theme_mod('ova_team_short_desc_field_type','textarea');

	$email = get_post_meta( $id, 'ova_team_met_email', true );
	$phone = get_post_meta( $id, 'ova_team_met_phone', true );

	$list_processing = get_post_meta( $id, 'ova_team_met_group_processing', true );

	$list_social = get_post_meta( $id, 'ova_team_met_group_icon', true );
	$experience = get_post_meta( $id, 'ova_team_met_experience', true );

	// show fields
	$show_image 	 = get_theme_mod('single_team_show_image','yes');
	$show_job 		 = get_theme_mod('single_team_show_job','yes');
	$show_name 		 = get_theme_mod('single_team_show_name','yes');
	$show_slogan 	 = get_theme_mod('single_team_show_slogan','yes');
	$show_short_desc = get_theme_mod('single_team_show_short_desc','yes');
	$show_experience = get_theme_mod('single_team_show_experience','yes');
	$show_email      = get_theme_mod('single_team_show_email','yes');
	$show_phone      = get_theme_mod('single_team_show_phone','yes');
	$show_process    = get_theme_mod('single_team_show_process','yes');
	$show_social     = get_theme_mod('single_team_show_social','yes');

?>


<div class="ova_team_single">
	
	<div class="summary">
		<div class="row_site">
			<div class="container_site">

				<div class="ova_info">

					<?php if( $show_image == 'yes' ) { ?>
						<div class="image-team">
							<img src="<?php echo esc_url( $image_src ); ?>" alt="<?php echo esc_attr( $image_alt ); ?>" 
								title="<?php echo esc_attr( $image_title ); ?>"
							>
						</div>
					<?php } ?>

					<div class="content_info">
						<div class="ova-info-content">

							<?php if( ! empty( $job ) && $show_job == 'yes' ) { ?>
								<p class="job">
									<?php echo esc_html( $job ); ?>
								</p>
							<?php } ?>

							<?php if( $show_name == 'yes' ) { ?>
								<h2 class="name">
									<?php echo get_the_title(); ?>	
								</h2>
							<?php } ?>

							<?php if( ! empty( $slogan ) && $show_slogan == 'yes' ) { ?>
								<?php if ( $slogan_field_type == 'wysiwyg'  ): ?>
									<div class="slogan">
										<?php echo apply_filters( 'ova_the_content', $slogan ); ?>
									</div>
								<?php else: ?>
									<div class="slogan">
										<?php echo esc_html($slogan); ?>
									</div>
								<?php endif; ?>
							<?php } ?>

							<?php if( ! empty( $short_desc ) && $show_short_desc == 'yes' ) { ?>
								<?php if ( $short_desc_field_type == 'wysiwyg'  ): ?>
									<div class="short-desc">
										<?php echo apply_filters( 'ova_the_content', $short_desc ); ?>
									</div>
								<?php else: ?>
									<div class="short-desc">
										<?php echo esc_html( $short_desc ); ?>
									</div>
								<?php endif; ?>
							<?php } ?>

							<?php if( ! empty( $experience ) && $show_experience == 'yes' ) { ?>
								<div class="ova-experience">
									<label>
										<?php echo esc_html__('Experience:', 'ova-team') ?>
									</label>
									<span><?php echo esc_html( $experience ); ?></span>
								</div>
							<?php } ?>

							<?php if( ! empty( $email ) && $show_email == 'yes' ) { ?>
								<div class="ova-email">
									<label>
										<?php echo esc_html__('Email:', 'ova-team') ?>
									</label>
									<a href="mailto:<?php echo esc_attr( $email ) ?>">
										<?php echo esc_html( $email ) ?>
									</a>
								</div>
							<?php } ?>
							<?php if( ! empty( $phone ) && $show_phone == 'yes' ) { ?>
								<div class="ova-phone">
									<label>
										<?php echo esc_html__('Phone:', 'ova-team') ?>
									</label>
									<a href="tel:<?php echo esc_attr( str_replace(' ', '', $phone) ); ?>" >
										<?php echo esc_html( $phone ) ?>	
									</a>
								</div>
							<?php } ?>

							<?php if ( $list_processing && $show_process == 'yes' ) : ?>
								<ul class="progress-bar">
									<?php foreach ( $list_processing as $key => $item):
										$text_process = $percent_process = '';

										if ( isset( $item['ova_team_met_text_process'] ) ){
											$text_process = $item['ova_team_met_text_process'];
										}
										if ( isset( $item['ova_team_met_percent_process'] ) ){
											$percent_process = $item['ova_team_met_percent_process'];
										}
									?>
										<li class="item">
											<p class="text">
												<?php echo esc_html( $text_process ); ?>
											</p>
											<div class="bar">
												<div class="percent" data-percent="<?php echo esc_attr( $percent_process ); ?>">
													<span class="num"><?php echo esc_html( $percent_process ); ?>%</span>
												</div>
											</div>
										</li>
									<?php endforeach; ?>
								</ul>
							<?php endif; ?>

							<?php if ( !empty($list_social) && $show_social == 'yes' ) : ?>
								<ul class="ova-social">
									<?php foreach( $list_social as $social ){
											$class_icon  = isset( $social['ova_team_met_class_icon_social'] ) ? $social['ova_team_met_class_icon_social'] : '';
											$link_social = isset( $social['ova_team_met_link_social'] ) ? $social['ova_team_met_link_social'] : '';
										?>
											<li class="icon">
												<a href="<?php echo esc_url( $link_social ); ?>" target="_blank" 
													aria-label="<?php esc_attr_e('Share social team link', 'ova-team')?>"
												>
													<i class="<?php echo esc_attr( $class_icon ) ?>" aria-hidden="true"></i>
												</a>
											</li>
									<?php }  ?>
								</ul>
							<?php endif; ?>
							
						</div>
					</div>
				</div>

			</div>
		</div>
	</div>

	<div class="ova_team_content">
		<?php if( have_posts() ) : while( have_posts() ) : the_post();
			the_content();
		endwhile; endif; wp_reset_postdata(); ?>
	</div>
	
</div>

<?php get_footer( );
