<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class Gimont_Elementor_Blog_Modern extends Widget_Base {

	
	public function get_name() {
		return 'gimont_elementor_blog_modern';
	}
	
	public function get_title() {
		return esc_html__( 'Blog Modern', 'gimont' );
	}
	
	public function get_icon() {
		return 'eicon-posts-ticker';
	}
	
	public function get_categories() {
		return [ 'gimont' ];
	}

	public function get_script_depends() {
		return [ '' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'gimont-elementor-blog-modern', GIMONT_URI.'/assets/scss/elementor/blogs/blog-modern.css' );
		return [];
	}
	
	// Add Your Controll In This Function
	protected function register_controls() {

		$args = array(
			'orderby' => 'name',
			'order' => 'ASC'
		);
  
		$categories 	= get_categories($args);
		$cate_array 	= array( 'all' => esc_html__( 'All categories', 'gimont' ) );
		if ($categories) {
			foreach ( $categories as $cate ) {
				$cate_array[$cate->slug] = $cate->cat_name;
			}
		} else {
			$cate_array[ esc_html__( 'No content Category found', 'gimont' ) ] = 0;
		}

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'gimont' ),
			]
		);

			$this->add_control(
				'version',
				[
					'label' => esc_html__( 'Version', 'gimont' ),
					'type' => Controls_Manager::SELECT,
					'default' => 'version_1',
					'options' => [
						'version_1' => esc_html__( 'Version 1', 'gimont' ),
						'version_2' => esc_html__( 'Version 2', 'gimont' ),
						'version_3' => esc_html__( 'Version 3', 'gimont' ),
					]
				]
			);
  
			$this->add_control(
				  'category',
				[
					'label' => esc_html__( 'Category', 'gimont' ),
					'type' => Controls_Manager::SELECT,
					'default' => 'all',
					'options' => $cate_array
				]
			);
  
			$this->add_control(
				'total_count',
				[
					'label' => esc_html__( 'Post Total', 'gimont' ),
					'type' => Controls_Manager::NUMBER,
					'default' => 3,
				]
			);
  
			$this->add_control(
				'number_column',
				[
					'label' => esc_html__( 'Columns', 'gimont' ),
					'type' => Controls_Manager::SELECT,
					'default' => 'column_3',
					'options' => [
						'column_1' => esc_html__( '1 Columns', 'gimont' ),
						'column_2' => esc_html__( '2 Columns', 'gimont' ),
						'column_3' => esc_html__( '3 Columns', 'gimont' ),
					],
				]
			);
  
			$this->add_control(
				'order',
				[
					'label' => esc_html__('Order', 'gimont'),
					'type' => Controls_Manager::SELECT,
					'default' => 'desc',
					'options' => [
						'asc' => esc_html__('Ascending', 'gimont'),
						'desc' => esc_html__('Descending', 'gimont'),
					]
				]
			);

			$this->add_control(
				'order_by',
				[
					'label' 	=> esc_html__('Order By', 'gimont'),
					'type' 		=> \Elementor\Controls_Manager::SELECT,
					'default' 	=> 'ID',
					'options' 	=> [
						'none' => esc_html__('None', 'gimont'),
						'ID' 	=> esc_html__('ID', 'gimont'),
						'title' => esc_html__('Title', 'gimont'),
						'date' 	=> esc_html__('Date', 'gimont'),
						'modified' => esc_html__('Modified', 'gimont'),
						'rand' 	=> esc_html__('Rand', 'gimont'),
					]
				]
			);
  
			$this->add_control(
				'text_readmore',
				[
					'label' => esc_html__( 'Text Read More', 'gimont' ),
					'type' => Controls_Manager::TEXT,
					'default' => esc_html__('View Post', 'gimont'),
					'condition' => [
					  	'show_read_more' => 'yes'
					],
				]
			);
  
			$this->add_control(
				'show_short_desc',
				[
					'label' => esc_html__( 'Show Short Description', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'gimont' ),
					'label_off' => esc_html__( 'Hide', 'gimont' ),
					'return_value' => 'yes',
					'default' => 'no',
				]
			);

			$this->add_control(
				'order_text',
				[
					'label' => esc_html__( 'Description Words Total', 'gimont' ),
					'type' => Controls_Manager::NUMBER,
					'default' => 12,
					'condition' => [
					  	'show_short_desc' => 'yes'
					],
				]
			);
  
			$this->add_control(
				'show_comment',
				[
					'label' => esc_html__( 'Show Comment', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'gimont' ),
					'label_off' => esc_html__( 'Hide', 'gimont' ),
					'return_value' => 'yes',
					'default' => 'no',
				]
			);
  
			$this->add_control(
				'show_date',
				[
					'label' => esc_html__( 'Show Date', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'gimont' ),
					'label_off' => esc_html__( 'Hide', 'gimont' ),
					'return_value' => 'yes',
					'default' => 'yes',
				 ]
			);

			$this->add_control(
				'show_category',
				[
					'label' => esc_html__( 'Show Category', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'gimont' ),
					'label_off' => esc_html__( 'Hide', 'gimont' ),
					'return_value' => 'yes',
					'default' => 'yes',
				 ]
			);
  
			$this->add_control(
				'show_author',
				[
					'label' => esc_html__( 'Show Author', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'gimont' ),
					'label_off' => esc_html__( 'Hide', 'gimont' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_read_more',
				[
					'label' => esc_html__( 'Show Read More', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'gimont' ),
					'label_off' => esc_html__( 'Hide', 'gimont' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_icon',
				[
					'label' => esc_html__( 'Show Icon', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'gimont' ),
					'label_off' => esc_html__( 'Hide', 'gimont' ),
					'return_value' => 'yes',
					'default' => 'yes',
					'condition' => [
					  	'show_read_more' => 'yes', 
					],
				]
			);

			$this->add_control(
				'icon_readmore',
				[
					'label' => esc_html__( 'Icon', 'gimont' ),
					'type' => \Elementor\Controls_Manager::ICONS,
					'default' 	=> [
						'value' 	=> 'gimonticon gimonticon-right',
						'library' 	=> 'all',	
					],
					'condition' => [
					  	'show_read_more' => 'yes', 
					  	'show_icon' => 'yes'
					],
				]
			);
  
		  $this->end_controls_section();
  
  
		  /* Begin General Style */
		  $this->start_controls_section(
			'general',
			  	[
				 	'label' => esc_html__( 'General', 'gimont' ),
				  	'tab' 	=> Controls_Manager::TAB_STYLE,
			  	]
		  	);

			  	$this->add_control(
					'general_gap',
					[
						'label' => esc_html__( 'Gap', 'gimont' ),
						'type' => \Elementor\Controls_Manager::SLIDER,
						'size_units' => [ 'px' ],
						'range' => [
							'px' => [
								'min' => 0,
								'max' => 60,
								'step' => 5,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .ova-blog-modern' => 'gap: {{SIZE}}{{UNIT}};',
						],
					]
				);

				$this->add_control(
				    'general_bg_color',
				    [
					    'label' => esc_html__( 'Background Color', 'gimont' ),
					    'type' => \Elementor\Controls_Manager::COLOR,
					    'selectors' => [
						    '{{WRAPPER}} .ova-blog-modern .item .content' => 'background-color : {{VALUE}};',
					    ],
				    ]
				);

			  	$this->add_responsive_control(
				  	'general_padding',
				  	[
					  	'label' => esc_html__( 'Padding', 'gimont' ),
					  	'type' => Controls_Manager::DIMENSIONS,
					  	'size_units' => [ 'px', 'em', '%' ],
					  	'selectors' => [
						  	'{{WRAPPER}} .ova-blog-modern .item .content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					  	],
				  	]
			  	);
  
		  	$this->end_controls_section();
		  	/* End General style */

		  	// BEGIN IMAGE STYLE
			$this->start_controls_section(
			    'section_blog_image',
			    [
				    'label' => esc_html__( 'Image', 'gimont' ),
				    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			    ]
			);

				$this->add_control(
					'blog_image_height',
					[
						'label' => esc_html__( 'Height', 'gimont' ),
						'type' => \Elementor\Controls_Manager::SLIDER,
						'size_units' => [ 'px', '%' ],
						'range' => [
							'px' => [
								'min' => 200,
								'max' => 500,
								'step' => 2,
							],
							'%' => [
								'min' => 0,
								'max' => 100,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .ova-blog-modern .item .media .box-img img' => 'height: {{SIZE}}{{UNIT}};',
						],
					]
				);

				$this->add_responsive_control(
				  	'blog_image_border_radius',
				  	[
					  	'label' => esc_html__( 'Border Radius', 'gimont' ),
					 	'type' => \Elementor\Controls_Manager::DIMENSIONS,
					  	'size_units' => [ 'px', 'em', '%' ],
					  	'selectors' => [
							'{{WRAPPER}} .ova-blog-modern .item .media .box-img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					  	],
				 	 ]
				);

				$this->add_group_control(
					\Elementor\Group_Control_Border::get_type(),
					[
						'name' => 'blog_image_border',
						'selector' => '{{WRAPPER}} .ova-blog-modern .item .media .box-img img',
					]
				);
  
		  	$this->end_controls_section();

		  	// BEGIN META STYLE
			$this->start_controls_section(
			    'section_meta',
			    [
				    'label' => esc_html__( 'Meta', 'gimont' ),
				    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			    ]
			);

			    $this->add_responsive_control(
				  	'margin_meta',
				  	[
					  	'label' => esc_html__( 'Margin', 'gimont' ),
					  	'type' => \Elementor\Controls_Manager::DIMENSIONS,
					  	'size_units' => [ 'px', 'em', '%' ],
					  	'selectors' => [
						  	'{{WRAPPER}} .ova-blog-modern .item .post-meta' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					  	],
				  	]
				);

				$this->add_group_control(
				    \Elementor\Group_Control_Typography::get_type(),
				    [
					    'name' => 'link_meta_typography',
					    'selector' => '{{WRAPPER}} .ova-blog-modern .item .item-meta .right',
				    ]
				);

				$this->add_control(
				    'link_color_meta',
				    [
					    'label' => esc_html__( 'Color', 'gimont' ),
					    'type' => \Elementor\Controls_Manager::COLOR,
					    'selectors' => [
					    	'{{WRAPPER}} .ova-blog-modern .item .item-meta .right' => 'color : {{VALUE}};',
						    '{{WRAPPER}} .ova-blog-modern .item .item-meta .right a' => 'color : {{VALUE}};',
					    ],
				    ]
				);

				$this->add_control(
				    'link_color_meta_hover',
				    [
					    'label' => esc_html__( 'Color Hover', 'gimont' ),
					    'type' => \Elementor\Controls_Manager::COLOR,
					    'selectors' => [
						    '{{WRAPPER}} .ova-blog-modern .item .item-meta .right a:hover' => 'color : {{VALUE}};',
					    ],
				    ]
				);

				$this->add_control(
				  	'icon_color_meta',
				  	[
					  	'label' => esc_html__( 'Icon Color', 'gimont' ),
					  	'type' => \Elementor\Controls_Manager::COLOR,
					  	'selectors' => [
						  	'{{WRAPPER}} .ova-blog-modern .item .item-meta .left' => 'color : {{VALUE}};',
					  	],
				  	]
				);

				$this->add_control(
					'icon_size_meta',
					[
						'label' => esc_html__( 'Icon Size', 'gimont' ),
						'type' => \Elementor\Controls_Manager::SLIDER,
						'size_units' => [ 'px', '%' ],
						'range' => [
							'px' => [
								'min' => 0,
								'max' => 70,
								'step' => 1,
							],
							'%' => [
								'min' => 0,
								'max' => 100,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .ova-blog-modern .item .item-meta .left i' => 'font-size: {{SIZE}}{{UNIT}};',
						],
					]
				);

				$this->add_group_control(
					\Elementor\Group_Control_Border::get_type(),
					[
						'name' => 'border_author',
						'selector' => '{{WRAPPER}} .ova-blog-modern .item .item-meta.wp-author .author img',
					]
				);
  
		  	$this->end_controls_section();
  
  
		  	//SECTION TAB STYLE TITLE
		  	$this->start_controls_section(
			  	'section_title',
			  	[
				  	'label' => esc_html__( 'Title', 'gimont' ),
				  	'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			  	]
		  	);
  
				$this->add_group_control(
					\Elementor\Group_Control_Typography::get_type(),
					[
						'name' => 'title_typography',
						'selector' => '{{WRAPPER}} .ova-blog-modern .item .content .post-title a',  
					]
				);
  
				$this->add_control(
					  'color_title',
					  [
						  'label' => esc_html__( 'Color', 'gimont' ),
						  'type' => \Elementor\Controls_Manager::COLOR,
						  'selectors' => [
							  '{{WRAPPER}} .ova-blog-modern .item .content .post-title a' => 'color : {{VALUE}};',
						  ],
					  ]
				);
		  
				$this->add_control(
					  'color_title_hover',
					  [
						  'label' => esc_html__( 'Color Hover', 'gimont' ),
						  'type' => \Elementor\Controls_Manager::COLOR,
						  'selectors' => [
							  '{{WRAPPER}} .ova-blog-modern .item:hover .content .post-title a' => 'color : {{VALUE}};',
						  ],
					  ]
				);
		  
				$this->add_responsive_control(
					  'margin_title',
					  [
						  'label' => esc_html__( 'Margin', 'gimont' ),
						  'type' => \Elementor\Controls_Manager::DIMENSIONS,
						  'size_units' => [ 'px', 'em', '%' ],
						  'selectors' => [
							  '{{WRAPPER}} .ova-blog-modern .item .content .post-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						  ],
					  ]
				);
		  
				$this->add_responsive_control(
					'padding_title',
					[
						'label' => esc_html__( 'Padding', 'gimont' ),
						'type' => \Elementor\Controls_Manager::DIMENSIONS,
						'size_units' => [ 'px', 'em', '%' ],
						'selectors' => [
							'{{WRAPPER}} .ova-blog-modern .item .content .post-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
					]
				);

				$this->add_group_control(
					\Elementor\Group_Control_Border::get_type(),
					[
						'name' => 'title_border',
						'selector' => '{{WRAPPER}} .ova-blog-modern .item .content .post-title',  
					]
				);
  
		    $this->end_controls_section();
		    //END SECTION TAB STYLE TITLE
  
   			// SHORT DESC STYLE
			$this->start_controls_section(
				'section_short_desc',
				[
					'label' => esc_html__( 'Short Description', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
					  	'show_short_desc' => 'yes'
					],
				]
			);
	  
				$this->add_group_control(
					\Elementor\Group_Control_Typography::get_type(),
					[
						'name' => 'short_descypography',
						'selector' => '{{WRAPPER}} .ova-blog-modern .item .content .short_desc p',
						  
					]
				);
		  
				$this->add_control(
					'color_short_desc',
					[
						'label' => esc_html__( 'Color', 'gimont' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							  '{{WRAPPER}} .ova-blog-modern .short_desc p' => 'color : {{VALUE}};',
						],
					]
				);
		  
				$this->add_responsive_control(
					'margin_short_desc',
					[
						'label' => esc_html__( 'Margin', 'gimont' ),
						'type' => \Elementor\Controls_Manager::DIMENSIONS,
						'size_units' => [ 'px', 'em', '%' ],
						'selectors' => [
							'{{WRAPPER}} .ova-blog-modern .item .content .short_desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
					]
				);
		  
				$this->add_responsive_control(
					'padding_short_desc',
					[
						'label' => esc_html__( 'Padding', 'gimont' ),
						'type' => \Elementor\Controls_Manager::DIMENSIONS,
						'size_units' => [ 'px', 'em', '%' ],
						'selectors' => [
							'{{WRAPPER}} .ova-blog-modern .item .content .short_desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
					]
				);  
	  
			$this->end_controls_section();
	  
		    //SECTION TAB STYLE READMORE
		    $this->start_controls_section(
			    'section_readmore',
			    [
				    'label' => esc_html__( 'View Post', 'gimont' ),
				    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			    ]
		    );
  
				$this->add_group_control(
					\Elementor\Group_Control_Typography::get_type(),
					[
					  'name' => 'readmore_typography',
					  'selector' => '{{WRAPPER}} .ova-blog-modern .item .read-more',
						  
					]
				);

				$this->add_control(
					'read_more_icon_size',
					[
						'label' => esc_html__( 'Icon Size', 'gimont' ),
						'type' => \Elementor\Controls_Manager::SLIDER,
						'size_units' => [ 'px', '%' ],
						'range' => [
							'px' => [
								'min' => 0,
								'max' => 40,
								'step' => 1,
							],
							'%' => [
								'min' => 0,
								'max' => 100,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .ova-blog-modern .item .read-more i' => 'font-size: {{SIZE}}{{UNIT}};',
						],
					]
				);

				$this->add_responsive_control(
				  	'padding_read_more',
					[
						'label' => esc_html__( 'Padding', 'gimont' ),
						'type' => \Elementor\Controls_Manager::DIMENSIONS,
						'size_units' => [ 'px', 'em', '%' ],
						'selectors' => [
							'{{WRAPPER}} .ova-blog-modern .item .read-more' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
					]
				);
  
	  
			  	$this->add_responsive_control(
				  	'margin_read_more',
					[
						'label' => esc_html__( 'Margin', 'gimont' ),
						'type' => \Elementor\Controls_Manager::DIMENSIONS,
						'size_units' => [ 'px', 'em', '%' ],
						'selectors' => [
							'{{WRAPPER}} .ova-blog-modern .item .read-more' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
					]
				);

			  	$this->start_controls_tabs(
					'read_more_tabs'
				);

					$this->start_controls_tab(
						'style_normal_tab',
						[
							'label' => esc_html__( 'Normal', 'gimont' ),
						]
					);

						$this->add_control(
							'color_link_read_more',
							[
								'label' => esc_html__( 'Link Color', 'gimont' ),
								'type' => \Elementor\Controls_Manager::COLOR,
								'selectors' => [
									'{{WRAPPER}} .ova-blog-modern .item .read-more' => 'color : {{VALUE}};',
								],
							]
						);

						$this->add_control(
							'color_icon_read_more',
							[
								'label' => esc_html__( 'Icon Color', 'gimont' ),
								'type' => \Elementor\Controls_Manager::COLOR,
								'selectors' => [
									'{{WRAPPER}} .ova-blog-modern .item .read-more i' => 'color : {{VALUE}};',
								],
							]
						);

						$this->add_group_control(
							\Elementor\Group_Control_Background::get_type(),
							[
								'name' => 'background_button_read_more',
								'types' => [ 'classic', 'gradient'],
								'selector' => '{{WRAPPER}} .ova-blog-modern .item .read-more',
							]
						);

					$this->end_controls_tab();

					$this->start_controls_tab(
						'style_hover_tab',
						[
							'label' => esc_html__( 'Hover', 'gimont' ),
						]
					);

						$this->add_control(
							'color_link_read_more_hover',
							[
								'label' => esc_html__( 'Link Color', 'gimont' ),
								'type' => \Elementor\Controls_Manager::COLOR,
								'selectors' => [
									'{{WRAPPER}} .ova-blog-modern .item .read-more:hover' => 'color : {{VALUE}};',
								],
							]
						);

						$this->add_control(
							'color_icon_read_more_hover',
							[
								'label' => esc_html__( 'Icon Color', 'gimont' ),
								'type' => \Elementor\Controls_Manager::COLOR,
								'selectors' => [
									'{{WRAPPER}} .ova-blog-modern .item .read-more:hover i' => 'color : {{VALUE}};',
								],
							]
						);

						$this->add_group_control(
							\Elementor\Group_Control_Background::get_type(),
							[
								'name' => 'background_button_read_more_hover',
								'types' => [ 'classic', 'gradient'],
								'selector' => '{{WRAPPER}} .ova-blog-modern .item:hover .read-more',
							]
						);

					$this->end_controls_tab();

				$this->end_controls_tabs();
  
		 	$this->end_controls_section();
		 
	  }
  
	  /**
	   * Render the widget output on the frontend.
	   *
	   * Written in PHP and used to generate the final HTML.
	   *
	   * @since 1.0.0
	   *
	   * @access protected
	   */
	  	protected function render() {

			$settings 			= $this->get_settings_for_display();

			$version 			= 	$settings['version'];

			$category 			= 	$settings['category'];
			$total_count 		= 	$settings['total_count'];
			$order 				= 	$settings['order'];
			$order_by 			= 	$settings['order_by'];
			$number_column 		= 	$settings['number_column'];
			$order_text	 		= 	$settings['order_text'] ? $settings['order_text'] : '12';

			$show_date 			= 	$settings['show_date'];
			$show_category 		= 	$settings['show_category'];
			$show_author 		= 	$settings['show_author'];
			$show_short_desc 	= 	$settings['show_short_desc'];
			$show_comment 		= 	$settings['show_comment'];
			$show_read_more		= 	$settings['show_read_more'];
			$text_readmore 		= 	$settings['text_readmore'];
			$show_icon 			=	$settings['show_icon'] ? $settings['show_icon'] : '' ;
			$icon_readmore 		=	$settings['icon_readmore'] ? $settings['icon_readmore'] : '';
  
			$args = [];
			
			if ($category == 'all') {
			  	$args = [
				  	'post_type' 		=> 'post',
				  	'post_status'       => 'publish',
				  	'posts_per_page' 	=> $total_count,
				  	'order' 			=> $order,
				  	'orderby' 			=> $order_by,
			  	];
			} else {
			  	$args = [
				  	'post_type' 		=> 	'post',
				  	'post_status'       => 'publish',
				  	'category_name'		=>	$category,
				  	'posts_per_page' 	=> 	$total_count,
				  	'order' 			=> 	$order,
				  	'orderby' 			=>  $order_by,
				  	'fields'			=> 	'ids'
			  	];
			}

			$blog = new \WP_Query($args);

			?>

			<ul class="ova-blog-modern <?php echo esc_attr( $version ).' '.esc_attr( $number_column ); ?>">

			  	<?php if($blog->have_posts()) : while($blog->have_posts()) : $blog->the_post(); ?>

				  	<li class="item">

				  		<?php if($version != 'version_3') { ?>
						  	<div class="media">
							  	<?php
							  	    $post_id    = get_the_ID();

							  		$size_img   = 'gimont_thumbnail';
								  	$thumbnail  = wp_get_attachment_image_url(get_post_thumbnail_id() , $size_img );
								  	$url_thumb  = $thumbnail ? $thumbnail : \Elementor\Utils::get_placeholder_image_src();

								  	$categories = get_the_category();
							  	?>

							  	<div class="box-img">
							  		<a href="<?php the_permalink(); ?>" rel="bookmark" title="<?php the_title_attribute(); ?>">
									  	<img src="<?php echo esc_url( $url_thumb ) ?>" alt="<?php the_title(); ?>">
								  	</a>
							  	</div>
						  	</div>
						<?php } ?>

					  	<div class="content">

					  		<ul class="post-meta">

						  		<?php if( $show_date == 'yes' ){ ?>
									<li class="item-meta post-date">
									  	<span class="left date">
										  	<i aria-hidden="true" class="fas fa-calendar-alt"></i>
									  	</span>
									  	<span class="right date">
										  	<span class="date-jMY"><?php the_time('M j, Y');?></span>
									  	</span>            
								  	</li>
								<?php } ?>

								<?php if( $show_author == 'yes' ){ ?>
								  	<li class="item-meta wp-author">
									  	<span class="left author">
										   	<i class="fas fa-user-circle"></i>
									  	</span>
									  	<span class="right post-author">
										  	<a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>">
											  	<?php the_author_meta( 'display_name' ); ?>
										  	</a>
									  	</span>
								  	</li>
						  		<?php } ;?>


							  	<?php if($show_comment == 'yes') : ?>
								  	<li class="item-meta  post-comment">
									  	<span class="left comment">
										  	<i aria-hidden="true" class="fas fa-comments"></i>
									  	</span>
									  	<span class="right comment">
										  	<?php
										  		comments_popup_link(
											  	esc_html__('0 Comments', 'gimont'), 
											  	esc_html__('1 Comment', 'gimont'), 
											  	' % '.esc_html__('Comments', 'gimont'),
		            							'',
											  	esc_html__( 'Comment off', 'gimont' ) )
										  	; ?> 
									  	</span>            
								  	</li>
							  	<?php endif; ?>

						  	</ul>

						  	<?php if( $show_category == 'yes' && is_array($categories) ) : 
						  		$first_category  = $categories[0]->name;
						  		$category_id     = get_cat_ID($first_category);
			   					$category_link   = get_category_link( $category_id );
						  	?>
							  	<div class="post-category">
							  		<a href="<?php echo esc_url( $category_link ); ?>">
								  		<span class="category"><?php echo esc_html( $first_category ); ?></span>
								  	</a>           
							  	</div>
						  	<?php endif; ?>
						  
						  	<h2 class="post-title">
							  	<a href="<?php the_permalink(); ?>" rel="bookmark" title="<?php the_title_attribute(); ?>">
									<?php the_title(); ?>
							  	</a>
						  	</h2>

						  	<?php if( $show_short_desc == 'yes' ) { ?> 
							  	<div class="short_desc">
								  	<p><?php echo gimont_custom_text(get_the_excerpt(), $order_text); ?></p>
							  	</div>
						  	<?php } ?>	

						</div>

						<?php if($version == 'version_3') { ?>
						  	<div class="media">
							  	<?php
							  	    $post_id    = get_the_ID();

							  		$size_img   = 'gimont_thumbnail';
								  	$thumbnail  = wp_get_attachment_image_url(get_post_thumbnail_id() , $size_img );
								  	$url_thumb  = $thumbnail ? $thumbnail : \Elementor\Utils::get_placeholder_image_src();

								  	$categories = get_the_category();
							  	?>

							  	<div class="box-img">
							  		<a href="<?php the_permalink(); ?>" rel="bookmark" title="<?php the_title_attribute(); ?>">
									  	<img src="<?php echo esc_url( $url_thumb ) ?>" alt="<?php the_title(); ?>">
								  	</a>
							  	</div>
						  	</div>
						<?php } ?>

					  	<?php if( $show_read_more == 'yes') { ?>
					  		<a href="<?php the_permalink(); ?>">	
							  	<div class="read-more">
							  		<span class="text-button">
									  	<?php echo esc_html( $text_readmore ); ?>
							  		</span>
							  		<?php if( $show_icon == 'yes') {
							  			\Elementor\Icons_Manager::render_icon( $icon_readmore, [ 'aria-hidden' => 'true' ] ); 
							  		} ?>
							  	</div>
							</a>
					  	<?php }?>
					  
					</li>	

			  <?php endwhile; endif; wp_reset_postdata(); ?>

			</ul>

		<?php
	}

	
}
$widgets_manager->register( new Gimont_Elementor_Blog_Modern() );