<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Gimont_Elementor_Icon_Box_2 extends Widget_Base {

	public function get_name() {
		return 'gimont_elementor_icon_box_2';
	}

	public function get_title() {
		return esc_html__( 'Ova Icon Box 2', 'gimont' );
	}

	public function get_icon() {
		return 'eicon-icon-box';
	}

	public function get_categories() {
		return [ 'gimont' ];
	}

	public function get_script_depends() {
		return [ '' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'gimont-elementor-icon-box-2', GIMONT_URI.'/assets/scss/elementor/icons/icon-box-2.css' );
		return [];
	}
	
	// Add Your Controll In This Function
	protected function register_controls() {

		/* Content */
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'gimont' ),
			]
		);

			$this->add_control(
				'icon',
				[
					'label' => esc_html__( 'Icon', 'gimont' ),
					'type' => \Elementor\Controls_Manager::ICONS,
					'default' => [
						'value' => 'fas fa-tree',
						'library' => 'all',
					],
				]
			);

			$this->add_control(
				'link',
				[
					'label' => esc_html__( 'Link', 'gimont' ),
					'type' => \Elementor\Controls_Manager::URL,
					'placeholder' => esc_html__( 'https://your-link.com', 'gimont' ),
					'options' => [ 'url', 'is_external', 'nofollow' ],
					'default' => [
						'url' => '',
						'is_external' => true,
						'nofollow' => false,
					],
					'label_block' => true,
				]
			);

			$this->add_control(
				'title',
				[
					'label' => esc_html__( 'Title', 'gimont' ),
					'type' => \Elementor\Controls_Manager::TEXTAREA,
					'default' => esc_html__( 'Providing City Services', 'gimont' ),
					'label_block' => true,
				]
			);

			$this->add_control(
				'description',
				[
					'label' => esc_html__( 'Description', 'gimont' ),
					'type' => \Elementor\Controls_Manager::TEXTAREA,
					'label_block' => true,
				]
			);

			$this->add_control(
				'text_button',
				[
					'label' => esc_html__( 'Text Button', 'gimont' ),
					'type' => \Elementor\Controls_Manager::TEXT,
				]
			);

			$this->add_responsive_control(
				'alignment',
				[
					'label' => esc_html__( 'Alignment', 'gimont' ),
					'type' => \Elementor\Controls_Manager::CHOOSE,
					'options' => [
						'left' => [
							'title' => esc_html__( 'Left', 'gimont' ),
							'icon' => 'eicon-text-align-left',
						],
						'center' => [
							'title' => esc_html__( 'Center', 'gimont' ),
							'icon' => 'eicon-text-align-center',
						],
						'right' => [
							'title' => esc_html__( 'Right', 'gimont' ),
							'icon' => 'eicon-text-align-right',
						],
					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .ova-icon-box-2' => 'text-align: {{VALUE}};',
					],
				]
			);

		$this->end_controls_section();

		/* General */
		$this->start_controls_section(
			'style_section',
			[
				'label' => esc_html__( 'General', 'gimont' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_responsive_control(
				'box_max_width',
				[
					'label' 		=> esc_html__( 'Max Width', 'gimont' ),
					'type' 			=> Controls_Manager::SLIDER,
					'size_units' 	=> [ 'px', '%' ],
					'range' => [
						'px' => [
							'min' 	=> 200,
							'max' 	=> 900,
							'step' 	=> 1,
						],
						'%' => [
							'min' 	=> 20,
							'max' 	=> 100,
							'step' 	=> 2,
						]
					],
					'selectors' 	=> [
						'{{WRAPPER}} .ova-icon-box-2' => 'max-width: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'item_padding',
				[
					'label' => esc_html__( 'Padding', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-icon-box-2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'item_box_shadow',
					'selector' => '{{WRAPPER}} .ova-icon-box-2',
				]
			);

			$this->start_controls_tabs(
				'item_style_tabs'
			);

				$this->start_controls_tab(
					'item_style_normal_tab',
					[
						'label' => esc_html__( 'Normal', 'gimont' ),
					]
				);

				$this->add_control(
					'item_bg',
					[
						'label' => esc_html__( 'Background', 'gimont' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-icon-box-2' => 'background: {{VALUE}}',
						],
					]
				);

				$this->end_controls_tab();

				$this->start_controls_tab(
						'item_style_hover_tab',
						[
							'label' => esc_html__( 'Hover', 'gimont' ),
						]
					);

				$this->add_control(
					'item_bg_hover',
					[
						'label' => esc_html__( 'Background', 'gimont' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-icon-box-2:hover' => 'background: {{VALUE}}',
						],
					]
				);

				$this->end_controls_tab();

			$this->end_controls_tabs();

		$this->end_controls_section();

		/* Icon */
		$this->start_controls_section(
				'icon_style_section',
				[
					'label' => esc_html__( 'Icon', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'icon_size',
				[
					'label' => esc_html__( 'Icon Size', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 100,
							'step' => 5,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ova-icon-box-2 .icon i' => 'font-size: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .ova-icon-box-2 .icon svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
					],
				]
			);		

			$this->add_responsive_control(
				'bg_icon_size',
				[
					'label' => esc_html__( 'Background Size', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 100,
							'step' => 5,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ova-icon-box-2 .icon::after' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
					],
				]
			);	

			$this->add_responsive_control(
				'icon_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-icon-box-2 .icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);	

			$this->start_controls_tabs(
				'icon_style_tabs'
			);

				$this->start_controls_tab(
					'icon_style_normal_tab',
					[
						'label' => esc_html__( 'Normal', 'gimont' ),
					]
				);

					$this->add_control(
						'icon_color',
						[
							'label' => esc_html__( 'Color', 'gimont' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-icon-box-2 .icon i' => 'color: {{VALUE}}',
								'{{WRAPPER}} .ova-icon-box-2 .icon svg' => 'fill: {{VALUE}}',
								'{{WRAPPER}} .ova-icon-box-2 .icon svg path' => 'fill: {{VALUE}}',
							],
						]
					);

					$this->add_control(
						'bg_icon_color',
						[
							'label' => esc_html__( 'Background Color', 'gimont' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-icon-box-2 .icon::after' => 'background-color: {{VALUE}}',
							],
						]
					);

				$this->end_controls_tab();

				$this->start_controls_tab(
					'icon_style_hover_tab',
					[
						'label' => esc_html__( 'Hover', 'gimont' ),
					]
				);

					$this->add_control(
						'icon_color_hover',
						[
							'label' => esc_html__( 'Color', 'gimont' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-icon-box-2:hover .icon i' => 'color: {{VALUE}}',
								'{{WRAPPER}} .ova-icon-box-2:hover .icon svg' => 'fill: {{VALUE}}',
								'{{WRAPPER}} .ova-icon-box-2:hover .icon svg path' => 'fill: {{VALUE}}',
							],
						]
					);

					$this->add_control(
						'bg_icon_color_hover',
						[
							'label' => esc_html__( 'Background Color', 'gimont' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-icon-box-2:hover .icon::after' => 'background-color: {{VALUE}}',
							],
						]
					);

				$this->end_controls_tab();

			$this->end_controls_tabs();

		$this->end_controls_section();

		/* Title */
		$this->start_controls_section(
			'title_style_section',
			[
				'label' => esc_html__( 'Title', 'gimont' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_responsive_control(
				'title_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-icon-box-2 .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'title_typography',
					'selector' => '{{WRAPPER}} .ova-icon-box-2 .title',
				]
			);

			$this->start_controls_tabs(
				'title_style_tabs'
				);

				$this->start_controls_tab(
						'title_style_normal_tab',
						[
							'label' => esc_html__( 'Normal', 'gimont' ),
						]
					);

				$this->add_control(
					'title_color',
					[
						'label' => esc_html__( 'Color', 'gimont' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-icon-box-2 .title' => 'color: {{VALUE}}',
						],
					]
				);

				$this->end_controls_tab();

				$this->start_controls_tab(
						'title_style_hover_tab',
						[
							'label' => esc_html__( 'Hover', 'gimont' ),
						]
					);

				$this->add_control(
					'title_color_hover',
					[
						'label' => esc_html__( 'Color', 'gimont' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-icon-box-2:hover .title' => 'color: {{VALUE}}',
						],
					]
				);

				$this->end_controls_tab();

			$this->end_controls_tabs();

		$this->end_controls_section();

		/* Description */
		$this->start_controls_section(
			'description_style_section',
			[
				'label' => esc_html__( 'Description', 'gimont' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_responsive_control(
				'description_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-icon-box-2 .description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'description_typography',
					'selector' => '{{WRAPPER}} .ova-icon-box-2 .description',
				]
			);

			$this->start_controls_tabs(
				'description_style_tabs'
				);

				$this->start_controls_tab(
						'description_style_normal_tab',
						[
							'label' => esc_html__( 'Normal', 'gimont' ),
						]
					);

				$this->add_control(
					'description_color',
					[
						'label' => esc_html__( 'Color', 'gimont' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-icon-box-2 .description' => 'color: {{VALUE}}',
						],
					]
				);

				$this->end_controls_tab();

				$this->start_controls_tab(
						'description_style_hover_tab',
						[
							'label' => esc_html__( 'Hover', 'gimont' ),
						]
					);

				$this->add_control(
					'description_color_hover',
					[
						'label' => esc_html__( 'Color', 'gimont' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-icon-box-2:hover .description' => 'color: {{VALUE}}',
						],
					]
				);

				$this->end_controls_tab();

			$this->end_controls_tabs();

		$this->end_controls_section();

		/* Text Button */
		$this->start_controls_section(
			'text_button_style_section',
			[
				'label' => esc_html__( 'Text Button', 'gimont' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'text_button_typography',
					'selector' => '{{WRAPPER}} .ova-icon-box-2 .text_button span',
				]
			);

			$this->start_controls_tabs(
				'text_button_style_tabs'
				);

				$this->start_controls_tab(
						'text_button_style_normal_tab',
						[
							'label' => esc_html__( 'Normal', 'gimont' ),
						]
					);

				$this->add_control(
					'text_button_color',
					[
						'label' => esc_html__( 'Color', 'gimont' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-icon-box-2 .text_button' => 'color: {{VALUE}}',
						],
					]
				);

				$this->end_controls_tab();

				$this->start_controls_tab(
					'text_button_style_hover_tab',
					[
						'label' => esc_html__( 'Hover', 'gimont' ),
					]
				);

				$this->add_control(
					'text_button_color_hover',
					[
						'label' => esc_html__( 'Color', 'gimont' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-icon-box-2:hover .text_button' => 'color: {{VALUE}}',
						],
					]
				);

				$this->end_controls_tab();

			$this->end_controls_tabs();

		$this->end_controls_section();

	}

	// Render Template Here
	protected function render() {
		$settings 	= $this->get_settings();

		$icon 		= $settings['icon'];
		$title 		= $settings['title'];
		$link 		= $settings['link'];
		$link_url 	= $link['url'];
		$target 	= '';
		$nofollow 	= '';
		if ( $link && $link_url) {
			$target 	= $link['is_external'] 	? 'target="_blank"' : '';
			$nofollow 	= $link['nofollow'] 	? 'rel="nofollow"' 	: '';
		}

		$description = $settings['description'];
		$text_button = $settings['text_button'];

		?>

			<div class="ova-icon-box-2">
				<div class="icon">
					<?php \Elementor\Icons_Manager::render_icon( $icon, [ 'aria-hidden' => 'true' ] ); ?>
				</div>
				<div class="info">
					<?php if(!empty($link_url)) { ?>
					<a href="<?php echo esc_url( $link_url ); ?>" <?php printf('%1$s %2$s', $target, $nofollow); ?>>
					<?php } ?>
						<h2 class="title"><?php echo esc_html( $title ); ?></h2>
					<?php if(!empty($link_url)) { ?>
					</a>
					<?php } ?>

					<?php if(!empty($description)) { ?>
						<p class="description"><?php echo esc_html( $description ); ?></p>
					<?php } ?>

					<?php if(!empty($link_url) && !empty($text_button) ) { ?>
						<a class="text_button" href="<?php echo esc_url( $link_url ); ?>" <?php printf('%1$s %2$s', $target, $nofollow); ?>>
							<span><?php echo esc_html( $text_button ); ?></span>
							<i aria-hidden="true" class="flaticonnew- flaticon-new-right"></i>
						</a>
					<?php } ?>

				</div>
			</div>

		<?php
	}

	
}
$widgets_manager->register( new Gimont_Elementor_Icon_Box_2() );