<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Gimont_Elementor_Search_All_Ajax extends Widget_Base {

	public function get_name() {
		return 'gimont_elementor_search_all_ajax';
	}

	public function get_title() {
		return esc_html__( 'Search All Ajax', 'gimont' );
	}

	public function get_icon() {
		return 'eicon-site-search';
	}

	public function get_categories() {
		return [ 'gimont' ];
	}

	public function get_script_depends() {
		return [ 'gimont-elementor-search-all-ajax' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'gimont-elementor-search-all-ajax', GIMONT_URI.'/assets/scss/elementor/searchs/search-all-ajax.css' );
		return [];
	}
	
	// Add Your Controll In This Function
	protected function register_controls() {

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'gimont' ),
			]
		);	

			// Add Class control

			$options_post_type = [ 
				'all'        => esc_html__( 'All', 'gimont' ),
				'post' 		 => esc_html__( 'Post', 'gimont' ),
				'page' 		 => esc_html__( 'Page', 'gimont' ),
				'event' 	 => esc_html__( 'Event', 'gimont' ),
				'team' 		 => esc_html__( 'Team', 'gimont' ),
				'career' 	 => esc_html__( 'Career', 'gimont' ),
				'give_forms' => esc_html__( 'Give', 'gimont' ),
				'collection' => esc_html__( 'Collection', 'gimont' ),
				'artist' 	 => esc_html__( 'Artist', 'gimont' ),
				'exhibition' => esc_html__( 'Exhibition', 'gimont' ),
				'ova_dep' 	 => esc_html__( 'Department', 'gimont' ),
				'ova_doc' 	 => esc_html__( 'Documentation', 'gimont' ),
				'ova_por' 	 => esc_html__( 'Portfolio', 'gimont' ),
				'ova_sev'	 => esc_html__( 'Service', 'gimont' ),
				'ova_dir'	 => esc_html__( 'Directory', 'gimont' ),
			];

			$this->add_control(
				'post_types',
				[
					'label' 		=> esc_html__( 'Post Types', 'gimont' ),
					'type' 			=> \Elementor\Controls_Manager::SELECT2,
					'label_block' 	=> true,
					'multiple' 		=> true,
					'options' 		=> $options_post_type,
					'default' 		=> ['all'],
				]
			);

			$this->add_control(
				'total',
				[
					'label' => esc_html__( 'Total Results', 'gimont' ),
					'type' => \Elementor\Controls_Manager::NUMBER,
					'min' => -1,
					'max' => 50,
					'default' => 20,
				]
			);

			$this->add_control(
				'search_by',
				[
					'label' => esc_html__( 'Search by', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'both',
					'options' => [
						'both' => esc_html__( 'Both', 'gimont' ),
						'post_title' => esc_html__( 'Title', 'gimont' ),
						'post_content' => esc_html__( 'Content', 'gimont' ),
					],
				]
			);

			$this->add_control(
				'order',
				[
					'label' 	=> esc_html__('Order', 'gimont'),
					'type' 	=> Controls_Manager::SELECT,
					'default' => 'asc',
					'options' => [
						'asc' 	=> esc_html__('Ascending', 'gimont'),
						'desc' 	=> esc_html__('Descending', 'gimont'),
					]
				]
			);

			$this->add_control(
				'orderby',
				[
					'label' 	=> esc_html__('Order By', 'gimont'),
					'type' 		=> \Elementor\Controls_Manager::SELECT,
					'default' 	=> 'title',
					'options' 	=> [
						'none' 		=> esc_html__('None', 'gimont'),
						'ID' 		=> esc_html__('ID', 'gimont'),
						'title' 	=> esc_html__('Title', 'gimont'),
						'date' 		=> esc_html__('Date', 'gimont'),
						'modified' 	=> esc_html__('Modified', 'gimont'),
					]
				]
			);

			$this->add_control(
				'placeholder',
				[
					'label' => esc_html__( 'Placeholder', 'gimont' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Search Here...', 'gimont' ),
				]
			);

			$this->add_control(
				'text_search',
				[
					'label' => esc_html__( 'Text Search Button', 'gimont' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Search', 'gimont' ),
				]
			);

			$this->add_control(
				'button_color',
				[
					'label' => esc_html__( 'Button Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-search-all-ajax button' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'button_bg_color',
				[
					'label' => esc_html__( 'Button Background Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-search-all-ajax button' => 'background-color: {{VALUE}}',
						
					],
				]
			);

			$this->add_control(
				'button_bg_color_hover',
				[
					'label' => esc_html__( 'Button Background Color Hover', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-search-all-ajax button:hover' => 'background-color: {{VALUE}}',

					],
				]
			);

		$this->end_controls_section();
	}

	// Render Template Here
	protected function render() {
		$settings = $this->get_settings();

		$placeholder = $settings['placeholder'];
		$text_search = $settings['text_search'];
		$post_types  = $settings['post_types'];
		$total  	 = $settings['total'];
		$order  	 = $settings['order'];
		$orderby  	 = $settings['orderby'];
		$search_by   = $settings['search_by'];

		?>

			<div class="ova-search-all-ajax" 
				data-total="<?php echo esc_attr($total);?>"
				data-order="<?php echo esc_attr($order);?>"
				data-orderby="<?php echo esc_attr($orderby);?>"
				data-post_types="<?php echo esc_attr(json_encode($post_types));?>" 
				data-search_by="<?php echo esc_attr($search_by);?>"
			>

				<form role="search" method="get" class="search-form" action="<?php echo home_url( '/' ); ?>">
					
					<div class="wrap_input">
						<input type="text" class="search-field" placeholder="<?php echo esc_attr($placeholder); ?>" 
							value="<?php echo get_search_query(); ?>" 
							aria-label="<?php echo esc_attr($placeholder); ?>"
							name="s"
						/>
						<span class="loader" aria-label="<?php esc_attr_e( 'Loader','gimont' ); ?>"></span>
					</div>
			
				    <button class="search-submit second_font" type="submit" title="<?php echo esc_attr($text_search); ?>">
				    	<?php echo esc_attr($text_search); ?>	
				    	<i class="gimonticon gimonticon-search-interface-symbol"></i>
				    </button>
		   			 	
				</form>		

				<div class="search-results"></div>

			</div>

		<?php
	}

	
}
$widgets_manager->register( new Gimont_Elementor_Search_All_Ajax() );