<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Gimont_Elementor_Testimonial_3 extends Widget_Base {

	public function get_name() {
		return 'gimont_elementor_testimonial_3';
	}

	public function get_title() {
		return esc_html__( 'Ova Testimonial 3', 'gimont' );
	}

	public function get_icon() {
		return 'eicon-testimonial';
	}

	public function get_categories() {
		return [ 'gimont' ];
	}

	public function get_script_depends() {
		return [ 'gimont-elementor-testimonial-3' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'gimont-elementor-testimonial-3', GIMONT_URI.'/assets/scss/elementor/testimonials/testimonial-3.css' );
		return [];
	}
	
	// Add Your Controll In This Function
	protected function register_controls() {

		/* Content */
		$this->start_controls_section(
				'section_content',
				[
					'label' => esc_html__( 'Content', 'gimont' ),
				]
			);

			$repeater = new \Elementor\Repeater();

				$repeater->add_control(
					'image_author',
					[
						'label'   => esc_html__( 'Author Image', 'gimont' ),
						'type'    => \Elementor\Controls_Manager::MEDIA,
						'default' => [
							'url' => Utils::get_placeholder_image_src(),
						],
					]
				);

				$repeater->add_control(
					'gallery',
					[
						'label' => esc_html__( 'Add Images', 'gimont' ),
						'type' => \Elementor\Controls_Manager::GALLERY,
						'show_label' => false,
						'default' => [
							[
								'url' => Utils::get_placeholder_image_src(),
							],
							[
								'url' => Utils::get_placeholder_image_src(),
							],
							[
								'url' => Utils::get_placeholder_image_src(),
							],
						],
					]
				);

				$repeater->add_control(
					'name_author',
					[
						'label'   => esc_html__( 'Author Name', 'gimont' ),
						'type'    => \Elementor\Controls_Manager::TEXT,
						'default' => 'Sarah albert',
					]
				);

				$repeater->add_control(
					'job',
					[
						'label'   => esc_html__( 'Job', 'gimont' ),
						'type'    => \Elementor\Controls_Manager::TEXT,
						'default' => esc_html__( 'CUSTOMER', 'gimont' ),
					]
				);

				$repeater->add_control(
					'testimonial',
					[
						'label'   => esc_html__( 'Testimonial ', 'gimont' ),
						'type'    => \Elementor\Controls_Manager::TEXTAREA,
						'default' => esc_html__( 'This is due to their excellent service, competitive pricing and customer support. It’s throughly refresing to get such a personal touch.', 'gimont' ),
					]
				);

				$this->add_control(
					'tab_item',
					[
						'label'       => esc_html__( 'Items Testimonial', 'gimont' ),
						'type'        => \Elementor\Controls_Manager::REPEATER,
						'fields'      => $repeater->get_controls(),
						'default' => [
							[
								'name_author' => 'Christine eve',
								'job' => esc_html__('.  Our Customer', 'gimont'),
							],
							[
								'name_author' => 'Aleesha brown',
								'job' => esc_html__('.  Our Customer', 'gimont'),
							],
						],
						'title_field' => '{{{ name_author }}}',
					]
				);

		$this->end_controls_section();

		/*****************************************************************
						START SECTION ADDITIONAL
		******************************************************************/

		$this->start_controls_section(
				'section_additional_options',
				[
					'label' => esc_html__( 'Additional Options', 'gimont' ),
				]
			);

			$this->add_control(
				'margin_items',
				[
					'label'   => esc_html__( 'Margin Right Items', 'gimont' ),
					'type'    => \Elementor\Controls_Manager::NUMBER,
					'default' => 30,
				]
				
			);

			$this->add_control(
				'slides_to_scroll',
				[
					'label'       => esc_html__( 'Slides to Scroll', 'gimont' ),
					'type'        => \Elementor\Controls_Manager::NUMBER,
					'description' => esc_html__( 'Set how many slides are scrolled per swipe.', 'gimont' ),
					'default'     => 1,
				]
			);

			$this->add_control(
				'pause_on_hover',
				[
					'label'   => esc_html__( 'Pause on Hover', 'gimont' ),
					'type'    => \Elementor\Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'gimont' ),
						'no'  => esc_html__( 'No', 'gimont' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'infinite',
				[
					'label'   => esc_html__( 'Infinite Loop', 'gimont' ),
					'type'    => \Elementor\Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'gimont' ),
						'no'  => esc_html__( 'No', 'gimont' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'autoplay',
				[
					'label'   => esc_html__( 'Autoplay', 'gimont' ),
					'type'    => \Elementor\Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'gimont' ),
						'no'  => esc_html__( 'No', 'gimont' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'autoplay_speed',
				[
					'label'     => esc_html__( 'Autoplay Speed', 'gimont' ),
					'type'      => \Elementor\Controls_Manager::NUMBER,
					'default'   => 3000,
					'step'      => 500,
					'condition' => [
						'autoplay' => 'yes',
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'smartspeed',
				[
					'label'   => esc_html__( 'Smart Speed', 'gimont' ),
					'type'    => \Elementor\Controls_Manager::NUMBER,
					'default' => 500,
				]
			);

		$this->end_controls_section();

		/* Item */
		$this->start_controls_section(
				'item_style_section',
				[
					'label' => esc_html__( 'Item', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'item_padding',
				[
					'label' => esc_html__( 'Padding', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-testimonial-3 .testimonial' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'item_background',
				[
					'label' => esc_html__( 'Backround', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-testimonial-3 .testimonial' => 'background: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Image */
		$this->start_controls_section(
				'image_style_section',
				[
					'label' => esc_html__( 'Image', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'image_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-testimonial-3 .testimonial .img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'image_border_radius',
				[
					'label' => esc_html__( 'Border Radius', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-testimonial-3 .testimonial .img img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .ova-testimonial-3 .testimonial .img-sm img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section();

		/* Job */
		$this->start_controls_section(
				'job_style_section',
				[
					'label' => esc_html__( 'Job', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'job_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-testimonial-3 .testimonial .job' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'job_typography',
					'selector' => '{{WRAPPER}} .ova-testimonial-3 .testimonial .job',
				]
			);

			$this->add_control(
				'job_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-testimonial-3 .testimonial .job' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Name */
		$this->start_controls_section(
				'name_style_section',
				[
					'label' => esc_html__( 'Author Name', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'name_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-testimonial-3 .testimonial .name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'name_typography',
					'selector' => '{{WRAPPER}} .ova-testimonial-3 .testimonial .name',
				]
			);

			$this->add_control(
				'name_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-testimonial-3 .testimonial .name' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Testimonial */
		$this->start_controls_section(
				'desc_style_section',
				[
					'label' => esc_html__( 'Testimonial', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'desc_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-testimonial-3 .testimonial .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'desc_typography',
					'selector' => '{{WRAPPER}} .ova-testimonial-3 .testimonial .desc',
				]
			);

			$this->add_control(
				'desc_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-testimonial-3 .testimonial .desc' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/****************************  END SECTION ADDITIONAL *********************/
	}

	// Render Template Here
	protected function render() {
		$settings 	= $this->get_settings();
		$tab_item 	= $settings['tab_item'];

		$data_options['slideBy']            = $settings['slides_to_scroll'] ? $settings['slides_to_scroll'] : 1;
		$data_options['margin']             = $settings['margin_items'] ? $settings['margin_items'] : 0;
		$data_options['autoplayHoverPause'] = $settings['pause_on_hover'] === 'yes' ? true : false;
		$data_options['loop']               = $settings['infinite'] === 'yes' ? true : false;
		$data_options['autoplay']           = $settings['autoplay'] === 'yes' ? true : false;
		$data_options['autoplayTimeout']    = $settings['autoplay_speed'];
		$data_options['smartSpeed']         = $settings['smartspeed'];
		$data_options['rtl']				= is_rtl() ? true : false;
		?>

		<div class="ova-testimonial-3">
			<div class="slide-testimonial" data-options="<?php echo esc_attr(json_encode($data_options)) ?>">
				<div class="owl-carousel owl-theme">
					<?php if ( ! empty( $tab_item ) ) : foreach( $tab_item as $item ): ?>
						<?php

						$testimonial 			= $item['testimonial'];
						$name_author 			= $item['name_author'];
						$image_author 			= $item['image_author'];
						$image_author_url 		= $image_author ? $image_author['url'] : Utils::get_placeholder_image_src();
						$image_author_alt 		= $name_author;
						$image_author_title 	= $name_author;
						$image_list 			= $item['gallery'];
						$job 					= $item['job'];

						if ( $image_author && $image_author['id'] ) {
							$image_author_alt = get_post_meta( $image_author['id'], '_wp_attachment_image_alt', true);
							$image_author_title = get_the_title( $image_author['id'] );
						}
						?>
						
						<div class="item">
							<div class="testimonial">
								<div class="wrapper">
									<div class="author">
										<div class="img">
											<img src="<?php echo esc_url( $image_author_url ); ?>" alt="<?php echo esc_attr( $image_author_alt ); ?>">
										</div>
										<?php if ( $image_list ): ?>
											<div class="img-sm">
												<?php foreach ( $image_list as $item): ?>
													<?php
														$img 		= $item;
														$img_url 	= $img ? $img['url'] : Utils::get_placeholder_image_src();
														$img_alt 	= $name_author;
														$img_title 	= $name_author;
													?>
													<img src="<?php echo esc_url( $img_url ); ?>" alt="<?php echo esc_attr( $img_alt ); ?>" title="<?php echo esc_attr( $img_title ); ?>">
												<?php endforeach; ?>
											</div>
										<?php endif; ?>
										
									</div>

									<div class="info">
										<?php if ( $testimonial ): ?>
											<p class="desc"><?php echo esc_html( $testimonial ); ?></p>
										<?php endif; ?>
										<div class="footer">
											<span class="name"><?php echo esc_html( $name_author ); ?></span>
											<span class="job"><?php echo esc_html( $job ); ?></span>
										</div>
									</div>

								</div>
							</div>
						</div>
					<?php endforeach; endif; ?>
				</div>
			</div>
		</div>
		<?php
	}
	
}

$widgets_manager->register( new Gimont_Elementor_Testimonial_3() );