<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Gimont_Elementor_Vertical_Slider extends Widget_Base {

	public function get_name() {
		return 'gimont_elementor_vertical_slider';
	}

	public function get_title() {
		return esc_html__( 'Vertical Slider', 'gimont' );
	}

	public function get_icon() {
		return 'eicon-slider-vertical';
	}

	public function get_categories() {
		return [ 'gimont' ];
	}

	public function get_script_depends() {
		wp_enqueue_style( 'animate', GIMONT_URI.'/assets/libs/animate.min.css');
		return [ 'gimont-elementor-vertical-slider' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'gimont-elementor-vertical-slider', GIMONT_URI.'/assets/scss/elementor/vertical-slider/vertical-slider.css' );
		return [];
	}
	
	// Add Your Controll In This Function
	protected function register_controls() {
		
		$this->start_controls_section(
				'section_content',
				[
					'label' => esc_html__( 'Content', 'gimont' ),
				]
			);

			$repeater = new \Elementor\Repeater();

				$repeater->add_control(
					'image',
					[
						'label'   => esc_html__( 'Image', 'gimont' ),
						'type'    => \Elementor\Controls_Manager::MEDIA,
						'default' => [
							'url' => Utils::get_placeholder_image_src(),
						],
					]
				);

				$repeater->add_control(
					'title',
					[
						'label' => esc_html__( 'Title', 'gimont' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'default' => esc_html__( 'Henry M. Becerra/', 'gimont' ),
					]
				);

				$repeater->add_control(
					'subtitle',
					[
						'label' => esc_html__( 'Subtitle', 'gimont' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'default' => esc_html__( 'CEO & Founder', 'gimont' ),
						'label_block' => true,
					]
				);

				$repeater->add_control(
					'description',
					[
						'label'   => esc_html__( 'Description ', 'gimont' ),
						'type'    => \Elementor\Controls_Manager::TEXTAREA,
						'rows' => 10,
						'default' => esc_html__( '"In the midst of winter, I found there was, within me, an invincible summer. And that makes me happy. For it says that no matter how hard the world pushes against me, within me, there’s something stronger – something better, pushing right back."', 'gimont' ),
					]
				);

				$this->add_control(
					'tab_item',
					[
						'label'       => esc_html__( 'Items description', 'gimont' ),
						'type'        => \Elementor\Controls_Manager::REPEATER,
						'fields'      => $repeater->get_controls(),
						'default' => [
							[
								'title' => esc_html__('Henry M. Becerra', 'gimont'),
							],
							[
								'title' => esc_html__('Mike Hardson', 'gimont'),
							],
							[
								'title' => esc_html__('Alisa Brown', 'gimont'),
							],
						],
						'title_field' => '{{{ title }}}',
					]
				);

		$this->end_controls_section();


		/*****************************************************************
						START SECTION ADDITIONAL
		******************************************************************/

		$this->start_controls_section(
				'section_additional_options',
				[
					'label' => esc_html__( 'Additional Options', 'gimont' ),
				]
			);

			$this->add_control(
				'margin_items',
				[
					'label'   => esc_html__( 'Margin Right Items', 'gimont' ),
					'type'    => \Elementor\Controls_Manager::NUMBER,
					'default' => 30,
				]
				
			);

			$this->add_control(
				'item_number',
				[
					'label'       => esc_html__( 'Item Number', 'gimont' ),
					'type'        => \Elementor\Controls_Manager::NUMBER,
					'description' => esc_html__( 'Number Item', 'gimont' ),
					'default'     => 1,
				]
			);

			$this->add_control(
				'slides_to_scroll',
				[
					'label'       => esc_html__( 'Slides to Scroll', 'gimont' ),
					'type'        => \Elementor\Controls_Manager::NUMBER,
					'description' => esc_html__( 'Set how many slides are scrolled per swipe.', 'gimont' ),
					'default'     => 1,
				]
			);

			$this->add_control(
				'pause_on_hover',
				[
					'label'   => esc_html__( 'Pause on Hover', 'gimont' ),
					'type'    => \Elementor\Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'gimont' ),
						'no'  => esc_html__( 'No', 'gimont' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'infinite',
				[
					'label'   => esc_html__( 'Infinite Loop', 'gimont' ),
					'type'    => \Elementor\Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'gimont' ),
						'no'  => esc_html__( 'No', 'gimont' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'autoplay',
				[
					'label'   => esc_html__( 'Autoplay', 'gimont' ),
					'type'    => \Elementor\Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'gimont' ),
						'no'  => esc_html__( 'No', 'gimont' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'autoplay_speed',
				[
					'label'     => esc_html__( 'Autoplay Speed', 'gimont' ),
					'type'      => \Elementor\Controls_Manager::NUMBER,
					'default'   => 3000,
					'step'      => 500,
					'condition' => [
						'autoplay' => 'yes',
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'smartspeed',
				[
					'label'   => esc_html__( 'Smart Speed', 'gimont' ),
					'type'    => \Elementor\Controls_Manager::NUMBER,
					'default' => 1000,
				]
			);

			$this->add_control(
				'dot_control',
				[
					'label'   => esc_html__( 'Show Dots', 'gimont' ),
					'type'    => \Elementor\Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'gimont' ),
						'no'  => esc_html__( 'No', 'gimont' ),
					],
					'frontend_available' => true,
				]
			);

		$this->end_controls_section();

		/****************************  END SECTION ADDITIONAL *********************/
		$this->start_controls_section(
				'section_general',
				[
					'label' => esc_html__( 'Items', 'gimont' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'items_padding',
				[
					'label' => esc_html__( 'Padding', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-vertical-slider .vertical-slider .card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name' => 'items_border',
					'selector' => '{{WRAPPER}} .ova-vertical-slider .vertical-slider .owl-stage-outer',
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'items_box_shadow',
					'selector' => '{{WRAPPER}} .ova-vertical-slider .vertical-slider .owl-stage-outer',
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Background::get_type(),
				[
					'name' => 'items_background',
					'types' => [ 'classic', 'gradient', 'video' ],
					'selector' => '{{WRAPPER}} .ova-vertical-slider .vertical-slider .card',
				]
			);

		$this->end_controls_section();

		/* Description */
		$this->start_controls_section(
				'desc_style_section',
				[
					'label' => esc_html__( 'Description', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'desc_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-vertical-slider .vertical-slider .card .wrapper .description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'desc_padding',
				[
					'label' => esc_html__( 'Padding', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-vertical-slider .vertical-slider .card .wrapper .description' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'desc_typography',
					'selector' => '{{WRAPPER}} .ova-vertical-slider .vertical-slider .card .wrapper .description',
				]
			);

			$this->add_control(
				'desc_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-vertical-slider .vertical-slider .card .wrapper .description' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Title */
		$this->start_controls_section(
				'title_style_section',
				[
					'label' => esc_html__( 'Title', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'title_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-vertical-slider .vertical-slider .card .wrapper .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'title_padding',
				[
					'label' => esc_html__( 'Padding', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-vertical-slider .vertical-slider .card .wrapper .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'title_typography',
					'selector' => '{{WRAPPER}} .ova-vertical-slider .vertical-slider .card .wrapper .title',
				]
			);

			$this->add_control(
				'title_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-vertical-slider .vertical-slider .card .wrapper .title' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Subtitle */
		$this->start_controls_section(
				'subtitle_style_section',
				[
					'label' => esc_html__( 'Subtitle', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'subtitle_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-vertical-slider .vertical-slider .card .wrapper .subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'subtitle_padding',
				[
					'label' => esc_html__( 'Padding', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-vertical-slider .vertical-slider .card .wrapper .subtitle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name' => 'subtitle_border',
					'selector' => '{{WRAPPER}} .ova-vertical-slider .vertical-slider .card .wrapper .subtitle',
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'subtitle_typography',
					'selector' => '{{WRAPPER}} .ova-vertical-slider .vertical-slider .card .wrapper .subtitle',
				]
			);

			$this->add_control(
				'subtitle_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-vertical-slider .vertical-slider .card .wrapper .subtitle' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();
		
		/* Dots */
		$this->start_controls_section(
				'dots_section_styles',
				[
					'label' => esc_html__( 'Dots', 'gimont' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
		
			$this->start_controls_tabs(
					'dots_style_tabs'
				);

				$this->start_controls_tab(
						'dots_style_normal_tab',
						[
							'label' => esc_html__( 'Normal', 'gimont' ),
						]
					);

				$this->add_control(
					'dot_color',
					[
						'label'     => esc_html__( 'Color', 'gimont' ),
						'type'      => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-vertical-slider .vertical-slider .owl-dots .owl-dot span' => 'background : {{VALUE}};',
							'{{WRAPPER}} .ova-vertical-slider .vertical-slider .owl-dots .owl-dot' => 'border-color : {{VALUE}};',
						],
					]
				);

				$this->end_controls_tab();

				$this->start_controls_tab(
						'dots_style_active_tab',
						[
							'label' => esc_html__( 'Active', 'gimont' ),
						]
					);

				$this->add_control(
					'dot_active_color',
					[
						'label'     => esc_html__( 'Color', 'gimont' ),
						'type'      => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-vertical-slider .vertical-slider .owl-dots .owl-dot.active span' => 'background : {{VALUE}};',
							'{{WRAPPER}} .ova-vertical-slider .vertical-slider .owl-dots .owl-dot.active' => 'border-color : {{VALUE}};',
						],
					]
				);

				$this->end_controls_tab();

			$this->end_controls_tabs();

		$this->end_controls_section();
	}

	// Render Template Here
	protected function render() {
		$settings 	= $this->get_settings();
		$tab_item 	= $settings['tab_item'];
		
		$data_options['items']              = $settings['item_number'];
		$data_options['slideBy']            = $settings['slides_to_scroll'];
		$data_options['margin']             = $settings['margin_items'];
		$data_options['autoplayHoverPause'] = $settings['pause_on_hover'] === 'yes' ? true : false;
		$data_options['loop']               = $settings['infinite'] === 'yes' ? true : false;
		$data_options['autoplay']           = $settings['autoplay'] === 'yes' ? true : false;
		$data_options['autoplayTimeout']    = $settings['autoplay_speed'];
		$data_options['smartSpeed']         = $settings['smartspeed'];
		$data_options['dots']               = $settings['dot_control'] === 'yes' ? true : false;
		$data_options['rtl']				= is_rtl() ? true: false;

		?>

			<section class="ova-vertical-slider">
				<div class="vertical-slider owl-carousel owl-theme" data-options="<?php echo esc_attr(json_encode($data_options)) ?>">
					<?php if ( ! empty( $tab_item ) ) : foreach( $tab_item as $key => $item ): 
						$image_url 		= $item['image']['url'];
						$image_id 		= $item['image']['id'];
						$image_alt 		= $item['title'];
						if ( $image_id ) {
							$image_alt = get_post_meta( $image_id, '_wp_attachment_image_alt', true );
							if ( ! $image_alt ) {
								$image_alt = get_the_title( $image_id );
							}
						}
						$subtitle 		= $item['subtitle'];
						$title 			= $item['title'];
						$description 	= $item['description'];
					?>
						<div class="item">
							<div class="card">
								<div class="wrapper">
									<div class="image">
										<?php if ($image_url): ?>
											<img src="<?php echo esc_url( $image_url ); ?>" alt="<?php echo esc_attr( $image_alt ); ?>">
										<?php endif; ?>
										<div class="icon">
											<i aria-hidden="true" class="flaticon flaticon-quotation"></i>						
										</div>
									</div>
									<div class="content">
										<?php if ( $description ): ?>
											<p class="description">
												<?php echo esc_html( $description ); ?>
											</p>
										<?php endif; ?>
										<div class="info-rating">
											<div class="info">
												<?php if ( $title ): ?>
													<h3 class="title"><?php echo esc_html( $title ); ?></h3>
												<?php endif; ?>
												<?php if ( $subtitle ): ?>
													<span class="subtitle"><?php echo esc_html( $subtitle ); ?></span>
												<?php endif; ?>
											</div>
											<div class="rating">
												<i class="fas fa-star"></i>
												<i class="fas fa-star"></i>
												<i class="fas fa-star"></i>
												<i class="fas fa-star"></i>
												<i class="fas fa-star"></i>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					<?php endforeach; endif; ?>
				</div>
			</section>

		<?php
	}

	
}
$widgets_manager->register( new Gimont_Elementor_Vertical_Slider() );