<?php if (!defined( 'ABSPATH' )) exit;

if (!class_exists( 'Gimont_Customize' )){

	class Gimont_Customize {
		
		public function __construct() {
	        add_action( 'customize_register', array( $this, 'gimont_customize_register' ) );
	    }

	    public function gimont_customize_register($wp_customize) {
	        
	        $this->gimont_init_remove_setting( $wp_customize );
	        $this->gimont_init_ova_typography( $wp_customize );
	        $this->gimont_init_ova_color( $wp_customize );
	        $this->gimont_init_ova_layout( $wp_customize );
	        $this->gimont_init_ova_header( $wp_customize );
	        $this->gimont_init_ova_footer( $wp_customize );
	        $this->gimont_init_ova_blog( $wp_customize );
	        $this->gimont_init_ova_archive_donation( $wp_customize );
	        $this->gimont_init_ova_single_donation( $wp_customize );
	        
	        if( gimont_is_woo_active() ){
	        	$this->gimont_init_ova_woo( $wp_customize );	
	        }
	   
	        do_action( 'gimont_customize_register', $wp_customize );
	    }

	    public function gimont_init_remove_setting( $wp_customize ){
	    	/* Remove Colors &  Header Image Customize */
			$wp_customize->remove_section('colors');
			$wp_customize->remove_section('header_image');

			$wp_customize->add_setting( 'logo', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> '',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
		    ) );

		    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'logo', array(
		        'label'    => esc_html__( 'Logo Default', 'gimont' ),
		        'section'  => 'title_tagline',
		        'settings' => 'logo'
		    )));
	    }
	    
	    /* Typo */
	    public function gimont_init_ova_typography($wp_customize){

	    		/* Body Pane ******************************/
				$wp_customize->add_section( 'typo_general' , array(
				    'title'      => esc_html__( 'Typography', 'gimont' ),
				    'priority'   => 1,
				    // 'panel' => 'typo_panel',
				) );

					/* General Typo */
					$wp_customize->add_setting( 'general_heading', array(
					  	'default' 			=> '',
					  	'sanitize_callback' 	=> 'sanitize_text_field' // Get function name 
					  
					) );


					/* Message */
					$wp_customize->add_setting( 'text_typo_message', array(
						'type' 				=> 'theme_mod', // or 'option'
						'capability' 		=> 'edit_theme_options',
						'theme_supports' 	=> '', // Rarely needed.
						'default' 			=> '',
						'transport' 		=> 'refresh', // or postMessage
						'sanitize_callback' => 'sanitize_text_field' // Get function name 
					) );

					$wp_customize->add_control(
						new Gimont_Customize_Control_Heading( 
						$wp_customize, 
						'text_typo_message', 
						array(
							'label'		=> esc_html__('Text Font','gimont'),
				            'section' 	=> 'typo_general',
				            'settings' 	=> 'text_typo_message',
						) )
					);

						/* Font Size */
						$wp_customize->add_setting( 'general_font_size', array(
						  'type' 				=> 'theme_mod', // or 'option'
						  'capability' 			=> 'edit_theme_options',
						  'theme_supports' 		=> '', // Rarely needed.
						  'default' 			=> '15px',
						  'transport' 			=> 'refresh', // or postMessage
						  'sanitize_callback' 	=> 'sanitize_text_field' // Get function name 
						  
						) );
						
						$wp_customize->add_control('general_font_size', array(
							'label' 		=> esc_html__('Font Size','gimont'),
							'description' 	=> esc_html__('Example: 16px, 1.2em','gimont'),
							'section' 		=> 'typo_general',
							'settings' 		=> 'general_font_size',
							'type' 			=>'text'
						));

						/* Line Height */
						$wp_customize->add_setting( 'general_line_height', array(
						  'type' 				=> 'theme_mod', // or 'option'
						  'capability' 			=> 'edit_theme_options',
						  'theme_supports' 		=> '', // Rarely needed.
						  'default' 			=> '1.9em',
						  'transport' 			=> 'refresh', // or postMessage
						  'sanitize_callback' 	=> 'sanitize_text_field' // Get function name 
						  
						) );
						
						$wp_customize->add_control('general_line_height', array(
							'label' 		=> esc_html__('Line height','gimont'),
							'description' 	=> esc_html__('Recommend use em. Example: 1.6em, 23px','gimont'),
							'section' 		=> 'typo_general',
							'settings' 		=> 'general_line_height',
							'type' 			=>'text'
						));

						/* Letter Space */
						$wp_customize->add_setting( 'general_letter_space', array(
						  'type' 				=> 'theme_mod', // or 'option'
						  'capability' 			=> 'edit_theme_options',
						  'theme_supports' 		=> '', // Rarely needed.
						  'default' 			=> '0px',
						  'transport' 			=> 'refresh', // or postMessage
						  'sanitize_callback' 	=> 'sanitize_text_field' // Get function name 
						) );
						
						$wp_customize->add_control('general_letter_space', array(
							'label' 		=> esc_html__('Letter Spacing','gimont'),
							'description' 	=> esc_html__('Example: 0px, 0.5em','gimont'),
							'section' 		=> 'typo_general',
							'settings' 		=> 'general_letter_space',
							'type' 			=>'text'
						));

				$wp_customize->add_control(
					new Gimont_Customize_Control_Heading( 
					$wp_customize, 
					'general_heading', 
					array(
						'label' 	=> esc_html__('Primary Font','gimont'),
			            'section' 	=> 'typo_general',
			            'settings' 	=> 'general_heading',
					) )
				);

				/* General Font */
				$wp_customize->add_setting( 'primary_font',
					array(
						'default' 			=> gimont_default_primary_font(),
						'sanitize_callback' => 'gimont_google_font_sanitization'
					)
				);
					$wp_customize->add_control( new Gimont_Google_Font_Select_Custom_Control( $wp_customize, 'primary_font',
						array(
							'label' 			=> esc_html__( 'Primary Font', 'gimont' ),
							'section' 			=> 'typo_general',
							'input_attrs' 		=> array(
								'font_count' 	=> 'all',
								'orderby' 		=> 'popular',
							),
						)
					) );

				/* Message */
				$wp_customize->add_setting( 'second_font_message', array(
					'type' 					=> 'theme_mod', // or 'option'
					'capability' 			=> 'edit_theme_options',
					'theme_supports' 		=> '', // Rarely needed.
					'default' 				=> '',
					'transport' 			=> 'refresh', // or postMessage
					'sanitize_callback' 	=> 'sanitize_text_field' // Get function name 
				  
				) );

				/* Custom Font */
				/* Message */
				$wp_customize->add_setting( 'custom_font_message', array(
					'type' 				=> 'theme_mod', // or 'option'
					'capability' 		=> 'edit_theme_options',
					'theme_supports' 	=> '', // Rarely needed.
					'default' 			=> '',
					'transport' 		=> 'refresh', // or postMessage
					'sanitize_callback' => 'sanitize_text_field' // Get function name 
				) );
				$wp_customize->add_control(
					new Gimont_Customize_Control_Heading( 
					$wp_customize, 
					'custom_font_message', 
					array(
						'label' 	=> esc_html__('Custom Font','gimont'),
			            'section' 	=> 'typo_general',
			            'settings' 	=> 'custom_font_message',
					) )
				);

					$wp_customize->add_control(
						new Gimont_Customize_Control_Heading( 
						$wp_customize, 
						'custom_font_message', 
						array(
							'label' 	=> esc_html__('Custom Font','gimont'),
				            'section' 	=> 'typo_general',
				            'settings' 	=> 'custom_font_message',
						) )
					);

					$wp_customize->add_setting( 'ova_custom_font', array(
						'type' 				=> 'theme_mod', // or 'option'
						'capability' 		=> 'edit_theme_options',
						'theme_supports' 	=> '', // Rarely needed.
						'default' 			=> '',
						'transport' 		=> 'refresh', // or postMessage
						'sanitize_callback' => 'sanitize_text_field' // Get function name 
					) );

					$wp_customize->add_control('ova_custom_font', array(
						'label' 		=> esc_html__('Custom Font','gimont'),
						'description' 	=> esc_html__('Step 1: Insert font-face in style.css file: Refer https://www.w3schools.com/cssref/css3_pr_font-face_rule.asp. Step 2: Insert font-family and font-weight like format: 
							["Perpetua", "Regular:Bold:Italic:Light"] | ["Name-Font", "Regular:Bold:Italic:Light"]. Step 3: Refresh customize page to display new font in dropdown font field.','gimont'),
						'section' 		=> 'typo_general',
						'settings' 		=> 'ova_custom_font',
						'type' 			=>'textarea'
					));
	    }


	     /* Color */
	    public function gimont_init_ova_color( $wp_customize ){

	    	/* Body Pane ******************************/
			$wp_customize->add_section( 'color_section' , array(
			    'title'      => esc_html__( 'Color', 'gimont' ),
			    'priority'   => 2,
			    // 'panel' => 'typo_panel',
			) );

				$wp_customize->add_setting( 'primary_color', array(
					'type' 				=> 'theme_mod', // or 'option'
					'capability' 		=> 'edit_theme_options',
					'theme_supports' 	=> '', // Rarely needed.
					'transport' 		=> 'refresh', // or postMessage
					'default'			=> gimont_default_primary_color(),
					'sanitize_callback' => 'sanitize_text_field' // Get function name 
				) );
				$wp_customize->add_control(
					new WP_Customize_Color_Control(
					$wp_customize, 
					'primary_color', 
					array(
						'label' 	=> esc_html__("Primary",'gimont'),
			            'section' 	=> 'color_section',
			            'settings' 	=> 'primary_color',

					) ) 
				);

				$wp_customize->add_setting( 'text_color', array(
				  'type' 				=> 'theme_mod', // or 'option'
				  'capability' 			=> 'edit_theme_options',
				  'theme_supports' 		=> '', // Rarely needed.
				  'default'				=> '#6B6C70',
				  'transport' 			=> 'refresh', // or postMessage
				  'sanitize_callback' 	=> 'sanitize_text_field' // Get function name 
				  
				) );
				$wp_customize->add_control(
					new WP_Customize_Color_Control(
					$wp_customize, 
					'text_color', 
					array(
						'label' 	=> esc_html__("Text",'gimont'),
			            'section' 	=> 'color_section',
			            'settings' 	=> 'text_color',
					) ) 
				);

				$wp_customize->add_setting( 'heading_color', array(
					'type' 				=> 'theme_mod', // or 'option'
					'capability' 		=> 'edit_theme_options',
					'theme_supports' 	=> '', // Rarely needed.
					'default'			=> '#051A53',		
					'transport' 		=> 'refresh', // or postMessage
					'sanitize_callback' => 'sanitize_text_field' // Get function name 
				) );
				$wp_customize->add_control(
					new WP_Customize_Color_Control(
					$wp_customize, 
					'heading_color', 
					array(
						'label' 	=> esc_html__("Heading",'gimont'),
			            'section' 	=> 'color_section',
			            'settings' 	=> 'heading_color',
					) ) 
				);

				$wp_customize->add_setting( 'light_color', array(
				  'type' 				=> 'theme_mod', // or 'option'
				  'capability' 			=> 'edit_theme_options',
				  'theme_supports' 		=> '', // Rarely needed.
				  'default'				=> '#D2d5DF',	
				  'transport' 			=> 'refresh', // or postMessage
				  'sanitize_callback' 	=> 'sanitize_text_field' // Get function name 
				  
				) );
				$wp_customize->add_control(
					new WP_Customize_Color_Control(
					$wp_customize, 
					'light_color', 
					array(
						'label' 	=> esc_html__("Light",'gimont'),
			            'section' 	=> 'color_section',
			            'settings' 	=> 'light_color',
					) ) 
				);
	    }


	    /* Layout */
	    public function gimont_init_ova_layout( $wp_customize ){

	    	$wp_customize->add_section( 'layout_section' , array(
			    'title'      => esc_html__( 'Layout', 'gimont' ),
			    'priority'   => 2,
			) );

				$wp_customize->add_setting( 'global_boxed_container_width', array(
					'type' 				=> 'theme_mod', // or 'option'
					'capability' 		=> 'edit_theme_options',
					'theme_supports' 	=> '', // Rarely needed.
					'default' 			=> '1290',
					'transport' 		=> 'refresh', // or postMessage
					'sanitize_callback' => 'sanitize_text_field' // Get function name 
				) );
				$wp_customize->add_control('global_boxed_container_width', array(
					'label' 	=> esc_html__('Container (px)','gimont'),
					'section' 	=> 'layout_section',
					'settings' 	=> 'global_boxed_container_width',
					'type' 		=>'number',
					'default' 	=> '1290'
				));

				$wp_customize->add_setting( 'global_layout', array(
					'type' 				=> 'theme_mod', // or 'option'
					'capability' 		=> 'edit_theme_options',
					'theme_supports' 	=> '', // Rarely needed.
					'default' 			=> 'layout_2r',
					'transport' 		=> 'refresh', // or postMessage
					'sanitize_callback' => 'sanitize_text_field' // Get function name 
				) );
				$wp_customize->add_control('global_layout', array(
					'label' 	=> esc_html__('Layout','gimont'),
					'section' 	=> 'layout_section',
					'settings' 	=> 'global_layout',
					'type' 		=> 'select',
					'choices' 	=> apply_filters( 'gimont_define_layout', array() )
				));

				$wp_customize->add_setting( 'global_sidebar_width', array(
					'type' 				=> 'theme_mod', // or 'option'
					'capability' 		=> 'edit_theme_options',
					'theme_supports' 	=> '', // Rarely needed.
					'default' 			=> '320',
					'transport' 		=> 'refresh', // or postMessage
					'sanitize_callback' => 'sanitize_text_field' // Get function name
				) );
				$wp_customize->add_control('global_sidebar_width', array(
					'label' 	=> esc_html__('Sidebar Width (px)','gimont'),
					'section' 	=> 'layout_section',
					'settings' 	=> 'global_sidebar_width',
					'type' 		=>'number'
				));
				
				$wp_customize->add_setting( 'global_wide_site', array(
					'type' 					=> 'theme_mod', // or 'option'
					'capability' 			=> 'edit_theme_options',
					'theme_supports' 		=> '', // Rarely needed.
					'default' 				=> 'wide',
					'transport' 			=> 'refresh', // or postMessage
					'sanitize_callback' 	=> 'sanitize_text_field' // Get function name
				  
				) );
				$wp_customize->add_control('global_wide_site', array(
					'label' 	=> esc_html__('Wide Site','gimont'),
					'section' 	=> 'layout_section',
					'settings' 	=> 'global_wide_site',
					'type' 		=> 'select',
					'choices' 	=> apply_filters( 'gimont_define_wide_boxed', array() )
				));

				$wp_customize->add_setting( 'global_boxed_offset', array(
				  'type' 				=> 'theme_mod', // or 'option'
				  'capability' 			=> 'edit_theme_options',
				  'theme_supports' 		=> '', // Rarely needed.
				  'default' 			=> '20',
				  'transport' 			=> 'refresh', // or postMessage
				  'sanitize_callback' 	=> 'sanitize_text_field' // Get function name
				  
				) );
				$wp_customize->add_control('global_boxed_offset', array(
					'label' 	=> esc_html__('Boxed Offset (px)','gimont'),
					'section' 	=> 'layout_section',
					'settings' 	=> 'global_boxed_offset',
					'type' 		=>'number',
					'default' 	=> '20'
				));
	    }

	    /* Header */
	    public function gimont_init_ova_header( $wp_customize ){

	    	$wp_customize->add_section( 'header_section' , array(
			    'title'      => esc_html__( 'Header', 'gimont' ),
			    'priority'   => 3,
			) );

				$wp_customize->add_setting( 'global_header', array(
					'type' 				=> 'theme_mod', // or 'option'
					'capability' 		=> 'edit_theme_options',
					'theme_supports' 	=> '', // Rarely needed.
					'default' 			=> 'default',
					'transport' 		=> 'refresh', // or postMessage
					'sanitize_callback' => 'sanitize_text_field' // Get function name
				) );
				$wp_customize->add_control('global_header', array(
					'label' 		=> esc_html__('Header Default','gimont'),
					'description' 	=> esc_html__('This isn\'t effect in Blog' ,'gimont'),
					'section' 		=> 'header_section',
					'settings' 		=> 'global_header',
					'type' 			=> 'select',
					'choices' 		=> apply_filters( 'gimont_list_header', array() )
				));
	    }

	    /* Footer */
	    public function gimont_init_ova_footer( $wp_customize ){

	    	$wp_customize->add_section( 'footer_section' , array(
			    'title'      => esc_html__( 'Footer', 'gimont' ),
			    'priority'   => 4,
			) );

				$wp_customize->add_setting( 'global_footer', array(
					'type' 				=> 'theme_mod', // or 'option'
					'capability' 		=> 'edit_theme_options',
					'theme_supports' 	=> '', // Rarely needed.
					'default' 			=> 'default',
					'transport' 		=> 'refresh', // or postMessage
					'sanitize_callback' => 'sanitize_text_field' // Get function name
				) );
				$wp_customize->add_control('global_footer', array(
					'label' 		=> esc_html__('Footer Default','gimont'),
					'description' 	=> esc_html__('This isn\'t effect in Blog' ,'gimont'),
					'section' 		=> 'footer_section',
					'settings' 		=> 'global_footer',
					'type' 			=> 'select',
					'choices' 		=> apply_filters( 'gimont_list_footer', array() )
				));
	    }


	    /* Blog */
	    public function gimont_init_ova_blog( $wp_customize ){

	    	$wp_customize->add_panel( 'blog_panel', array(
			    'title'		=> esc_html__( 'Blog', 'gimont' ),
			    'priority' 	=> 5,
			) );

				$wp_customize->add_section( 'blog_section' , array(
				    'title' 	=> esc_html__( 'Archive', 'gimont' ),
				    'priority' 	=> 30,
				    'panel' 	=> 'blog_panel',
				) );

					$wp_customize->add_setting( 'blog_template', array(
						'type' 				=> 'theme_mod', // or 'option'
						'capability'		=> 'edit_theme_options',
						'theme_supports' 	=> '', // Rarely needed.
						'default' 			=> 'default',
						'transport' 		=> 'refresh', // or postMessage
						'sanitize_callback' => 'sanitize_text_field' // Get function name
					) );

					$wp_customize->add_control('blog_template', array(
						'label' 	=> esc_html__('Type','gimont'),
						'section' 	=> 'blog_section',
						'settings' 	=> 'blog_template',
						'type' 		=>'select',
						'choices' 	=> array(
							'default' 	=> esc_html__('Default', 'gimont'),
							'grid'		=> esc_html__('Grid', 'gimont'),
							'masonry' 	=> esc_html__('Masonry', 'gimont'),
						)
					));

					$wp_customize->add_setting( 'blog_archive_show_media', array(
						'type' 				=> 'theme_mod', // or 'option'
						'capability' 		=> 'edit_theme_options',
						'theme_supports' 	=> '', // Rarely needed.
						'default' 			=> 'yes',
						'transport' 		=> 'refresh', // or postMessage
						'sanitize_callback' => 'sanitize_text_field' // Get function name
					) );
					
					$wp_customize->add_control('blog_archive_show_media', array(
						'label' 	=> esc_html__('Show Media','gimont'),
						'section' 	=> 'blog_section',
						'settings' 	=> 'blog_archive_show_media',
						'type' 		=>'select',
						'choices' 	=> array(
							'yes' 	=> esc_html__('Yes', 'gimont'),
							'no' 	=> esc_html__('No', 'gimont'),
						)
					));

					$wp_customize->add_setting( 'blog_archive_show_title', array(
						'type' 				=> 'theme_mod', // or 'option'
						'capability' 		=> 'edit_theme_options',
						'theme_supports' 	=> '', // Rarely needed.
						'default' 			=> 'yes',
						'transport' 		=> 'refresh', // or postMessage
						'sanitize_callback' => 'sanitize_text_field' // Get function name
					) );
					
					$wp_customize->add_control('blog_archive_show_title', array(
						'label' 	=> esc_html__('Show Title','gimont'),
						'section' 	=> 'blog_section',
						'settings' 	=> 'blog_archive_show_title',
						'type' 		=>'select',
						'choices' 	=> array(
							'yes' 	=> esc_html__('Yes', 'gimont'),
							'no' 	=> esc_html__('No', 'gimont'),
						)
					));

					$wp_customize->add_setting( 'blog_archive_show_date', array(
						'type' 				=> 'theme_mod', // or 'option'
						'capability' 		=> 'edit_theme_options',
						'theme_supports' 	=> '', // Rarely needed.
						'default' 			=> 'yes',
						'transport' 		=> 'refresh', // or postMessage
						'sanitize_callback' => 'sanitize_text_field' // Get function name
					) );
					
					$wp_customize->add_control('blog_archive_show_date', array(
						'label' 	=> esc_html__('Show Date','gimont'),
						'section' 	=> 'blog_section',
						'settings' 	=> 'blog_archive_show_date',
						'type' 		=>'select',
						'choices' 	=> array(
							'yes' 	=> esc_html__('Yes', 'gimont'),
							'no' 	=> esc_html__('No', 'gimont'),
						)
					));

					$wp_customize->add_setting( 'blog_archive_show_cat', array(
						'type' 				=> 'theme_mod', // or 'option'
						'capability' 		=> 'edit_theme_options',
						'theme_supports' 	=> '', // Rarely needed.
						'default' 			=> 'yes',
						'transport' 		=> 'refresh', // or postMessage
						'sanitize_callback' => 'sanitize_text_field' // Get function name
					) );
					
					$wp_customize->add_control('blog_archive_show_cat', array(
						'label' 	=> esc_html__('Show Category','gimont'),
						'section' 	=> 'blog_section',
						'settings' 	=> 'blog_archive_show_cat',
						'type' 		=>'select',
						'choices' 	=> array(
							'yes' 	=> esc_html__('Yes', 'gimont'),
							'no' 	=> esc_html__('No', 'gimont'),
						)
					));

					$wp_customize->add_setting( 'blog_archive_show_author', array(
						'type' 				=> 'theme_mod', // or 'option'
						'capability' 		=> 'edit_theme_options',
						'theme_supports' 	=> '', // Rarely needed.
						'default' 			=> 'no',
						'transport' 		=> 'refresh', // or postMessage
						'sanitize_callback' => 'sanitize_text_field' // Get function name
					) );
					
					$wp_customize->add_control('blog_archive_show_author', array(
						'label' 	=> esc_html__('Show Author','gimont'),
						'section' 	=> 'blog_section',
						'settings' 	=> 'blog_archive_show_author',
						'type' 		=>'select',
						'choices' 	=> array(
							'yes' 	=> esc_html__('Yes', 'gimont'),
							'no' 	=> esc_html__('No', 'gimont'),
						)
					));

					$wp_customize->add_setting( 'blog_archive_show_comment', array(
						'type' 				=> 'theme_mod', // or 'option'
						'capability' 		=> 'edit_theme_options',
						'theme_supports' 	=> '', // Rarely needed.
						'default' 			=> 'yes',
						'transport' 		=> 'refresh', // or postMessage
						'sanitize_callback' => 'sanitize_text_field' // Get function name
					) );
					
					$wp_customize->add_control('blog_archive_show_comment', array(
						'label' 	=> esc_html__('Show Comment','gimont'),
						'section' 	=> 'blog_section',
						'settings' 	=> 'blog_archive_show_comment',
						'type' 		=>'select',
						'choices' 	=> array(
							'yes' 	=> esc_html__('Yes', 'gimont'),
							'no' 	=> esc_html__('No', 'gimont'),
						)
					));

					$wp_customize->add_setting( 'blog_archive_show_excerpt', array(
						'type' 				=> 'theme_mod', // or 'option'
						'capability' 		=> 'edit_theme_options',
						'theme_supports' 	=> '', // Rarely needed.
						'default' 			=> 'yes',
						'transport' 		=> 'refresh', // or postMessage
						'sanitize_callback' => 'sanitize_text_field' // Get function name
					) );
					
					$wp_customize->add_control('blog_archive_show_excerpt', array(
						'label' 	=> esc_html__('Show Excerpt','gimont'),
						'section' 	=> 'blog_section',
						'settings' 	=> 'blog_archive_show_excerpt',
						'type' 		=>'select',
						'choices' 	=> array(
							'yes' 	=> esc_html__('Yes', 'gimont'),
							'no' 	=> esc_html__('No', 'gimont'),
						)
					));

					$wp_customize->add_setting( 'blog_archive_show_readmore', array(
						'type' 				=> 'theme_mod', // or 'option'
						'capability' 		=> 'edit_theme_options',
						'theme_supports' 	=> '', // Rarely needed.
						'default' 			=> 'yes',
						'transport' 		=> 'refresh', // or postMessage
						'sanitize_callback' => 'sanitize_text_field' // Get function name
					) );
					
					$wp_customize->add_control('blog_archive_show_readmore', array(
						'label' 	=> esc_html__('Show Read More','gimont'),
						'section' 	=> 'blog_section',
						'settings' 	=> 'blog_archive_show_readmore',
						'type' 		=>'select',
						'choices' 	=> array(
							'yes' 	=> esc_html__('Yes', 'gimont'),
							'no' 	=> esc_html__('No', 'gimont'),
						)
					));

					$wp_customize->add_setting( 'blog_layout', array(
					  	'type' 				=> 'theme_mod', // or 'option'
					  	'capability' 		=> 'edit_theme_options',
					  	'theme_supports' 	=> '', // Rarely needed.
					  	'default' 			=> 'layout_2r',
					  	'transport' 		=> 'refresh', // or postMessage
					  	'sanitize_callback' => 'sanitize_text_field' // Get function name 
					) );

					$wp_customize->add_control('blog_layout', array(
						'label' 	=> esc_html__('Layout','gimont'),
						'section' 	=> 'blog_section',
						'settings' 	=> 'blog_layout',
						'type' 		=> 'select',
						'choices' 	=> apply_filters( 'gimont_define_layout', array() )
					));
					
					$wp_customize->add_setting( 'blog_header', array(
					  	'type' 				=> 'theme_mod', // or 'option'
					  	'capability' 			=> 'edit_theme_options',
					  	'theme_supports' 		=> '', // Rarely needed.
					  	'default' 			=> 'default',
					  	'transport' 			=> 'refresh', // or postMessage
					  	'sanitize_callback' 	=> 'sanitize_text_field' // Get function name 
					) );

					$wp_customize->add_control('blog_header', array(
						'label' 	=> esc_html__('Header','gimont'),
						'section' 	=> 'blog_section',
						'settings' 	=> 'blog_header',
						'type' 		=> 'select',
						'choices' 	=> apply_filters( 'gimont_list_header', array() )
					));

					$wp_customize->add_setting( 'blog_footer', array(
						'type' 				=> 'theme_mod', // or 'option'
						'capability' 		=> 'edit_theme_options',
						'theme_supports' 	=> '', // Rarely needed.
						'default' 			=> 'default',
						'transport' 		=> 'refresh', // or postMessage
						'sanitize_callback' => 'sanitize_text_field' // Get function name 
					) );

					$wp_customize->add_control('blog_footer', array(
						'label' 	=> esc_html__('Footer','gimont'),
						'section' 	=> 'blog_section',
						'settings' 	=> 'blog_footer',
						'type' 		=> 'select',
						'choices' 	=> apply_filters( 'gimont_list_footer', array() )
					));

				$wp_customize->add_section( 'single_section' , array(
				    'title' 	=> esc_html__( 'Single', 'gimont' ),
				    'priority' 	=> 30,
				    'panel' 	=> 'blog_panel',
				) );	

					$wp_customize->add_setting( 'single_layout', array(
						'type' 				=> 'theme_mod', // or 'option'
						'capability' 		=> 'edit_theme_options',
						'theme_supports' 	=> '', // Rarely needed.
						'default' 			=> 'layout_2r',
						'transport' 		=> 'refresh', // or postMessage
						'sanitize_callback' => 'sanitize_text_field' // Get function name 
					) );
					$wp_customize->add_control('single_layout', array(
						'label' 	=> esc_html__('Layout','gimont'),
						'section' 	=> 'single_section',
						'settings' 	=> 'single_layout',
						'type' 		=> 'select',
						'choices' 	=> apply_filters( 'gimont_define_layout', array() )
					));

					$wp_customize->add_setting( 'blog_single_show_media', array(
					  	'type' 				=> 'theme_mod', // or 'option'
					  	'capability' 			=> 'edit_theme_options',
					  	'theme_supports' 		=> '', // Rarely needed.
					  	'default' 			=> 'yes',
					  	'transport' 			=> 'refresh', // or postMessage
					  	'sanitize_callback' 	=> 'sanitize_text_field' // Get function name
					) );
					
					$wp_customize->add_control('blog_single_show_media', array(
						'label' 	=> esc_html__('Show Media','gimont'),
						'section' 	=> 'single_section',
						'settings' 	=> 'blog_single_show_media',
						'type' 		=>'select',
						'choices' 	=> array(
							'yes' 	=> esc_html__('Yes', 'gimont'),
							'no' 	=> esc_html__('No', 'gimont'),
						)
					));

					$wp_customize->add_setting( 'blog_single_show_title', array(
						'type' 				=> 'theme_mod', // or 'option'
						'capability' 		=> 'edit_theme_options',
						'theme_supports' 	=> '', // Rarely needed.
						'default' 			=> 'yes',
						'transport' 		=> 'refresh', // or postMessage
						'sanitize_callback' => 'sanitize_text_field' // Get function name
					) );
					
					$wp_customize->add_control('blog_single_show_title', array(
						'label' 	=> esc_html__('Show Title','gimont'),
						'section' 	=> 'single_section',
						'settings' 	=> 'blog_single_show_title',
						'type' 		=>'select',
						'choices' 	=> array(
							'yes' 	=> esc_html__('Yes', 'gimont'),
							'no' 	=> esc_html__('No', 'gimont'),
						)
					));

					$wp_customize->add_setting( 'blog_single_show_date', array(
						'type' 				=> 'theme_mod', // or 'option'
						'capability' 		=> 'edit_theme_options',
						'theme_supports' 	=> '', // Rarely needed.
						'default' 			=> 'yes',
						'transport' 		=> 'refresh', // or postMessage
						'sanitize_callback' => 'sanitize_text_field' // Get function name
					) );
					
					$wp_customize->add_control('blog_single_show_date', array(
						'label' 	=> esc_html__('Show Date','gimont'),
						'section' 	=> 'single_section',
						'settings' 	=> 'blog_single_show_date',
						'type' 		=>'select',
						'choices' 	=> array(
							'yes' 	=> esc_html__('Yes', 'gimont'),
							'no' 	=> esc_html__('No', 'gimont'),
						)
					));

					$wp_customize->add_setting( 'blog_single_show_cat', array(
						'type' 				=> 'theme_mod', // or 'option'
						'capability' 		=> 'edit_theme_options',
						'theme_supports' 	=> '', // Rarely needed.
						'default' 			=> 'yes',
						'transport' 		=> 'refresh', // or postMessage
						'sanitize_callback' => 'sanitize_text_field' // Get function name 
					) );
					
					$wp_customize->add_control('blog_single_show_cat', array(
						'label' 	=> esc_html__('Show Category','gimont'),
						'section' 	=> 'single_section',
						'settings' 	=> 'blog_single_show_cat',
						'type' 		=>'select',
						'choices' 	=> array(
							'yes' 	=> esc_html__('Yes', 'gimont'),
							'no' 	=> esc_html__('No', 'gimont'),
						)
					));

					$wp_customize->add_setting( 'blog_single_show_author', array(
						'type' 				=> 'theme_mod', // or 'option'
						'capability' 		=> 'edit_theme_options',
						'theme_supports' 	=> '', // Rarely needed.
						'default' 			=> 'no',
						'transport' 		=> 'refresh', // or postMessage
						'sanitize_callback' => 'sanitize_text_field' // Get function name 
					) );
					
					$wp_customize->add_control('blog_single_show_author', array(
						'label' 	=> esc_html__('Show Author','gimont'),
						'section' 	=> 'single_section',
						'settings' 	=> 'blog_single_show_author',
						'type' 		=>'select',
						'choices' 	=> array(
							'yes' 	=> esc_html__('Yes', 'gimont'),
							'no' 	=> esc_html__('No', 'gimont'),
						)
					));

					$wp_customize->add_setting( 'blog_single_show_comment', array(
						'type' 				=> 'theme_mod', // or 'option'
						'capability' 		=> 'edit_theme_options',
						'theme_supports' 	=> '', // Rarely needed.
						'default' 			=> 'yes',
						'transport' 		=> 'refresh', // or postMessage
						'sanitize_callback' => 'sanitize_text_field' // Get function name 
					) );
					
					$wp_customize->add_control('blog_single_show_comment', array(
						'label' 	=> esc_html__('Show Comment','gimont'),
						'section' 	=> 'single_section',
						'settings' 	=> 'blog_single_show_comment',
						'type' 		=>'select',
						'choices' 	=> array(
							'yes' 	=> esc_html__('Yes', 'gimont'),
							'no' 	=> esc_html__('No', 'gimont'),
						)
					));

					$wp_customize->add_setting( 'blog_single_show_content', array(
						'type' 				=> 'theme_mod', // or 'option'
						'capability' 		=> 'edit_theme_options',
						'theme_supports' 	=> '', // Rarely needed.
						'default' 			=> 'yes',
						'transport' 		=> 'refresh', // or postMessage
						'sanitize_callback' => 'sanitize_text_field' // Get function name 
					) );
					
					$wp_customize->add_control('blog_single_show_content', array(
						'label' 	=> esc_html__('Show Content','gimont'),
						'section' 	=> 'single_section',
						'settings' 	=> 'blog_single_show_content',
						'type' 		=>'select',
						'choices' 	=> array(
							'yes' 	=> esc_html__('Yes', 'gimont'),
							'no' 	=> esc_html__('No', 'gimont'),
						)
					));

					$wp_customize->add_setting( 'blog_single_show_tag', array(
						'type' 				=> 'theme_mod', // or 'option'
						'capability' 		=> 'edit_theme_options',
						'theme_supports' 	=> '', // Rarely needed.
						'default' 			=> 'yes',
						'transport' 		=> 'refresh', // or postMessage
						'sanitize_callback' => 'sanitize_text_field' // Get function name
					) );
					
					$wp_customize->add_control('blog_single_show_tag', array(
						'label' 	=> esc_html__('Show Tag','gimont'),
						'section' 	=> 'single_section',
						'settings' 	=> 'blog_single_show_tag',
						'type' 		=>'select',
						'choices' 	=> array(
							'yes' 	=> esc_html__('Yes', 'gimont'),
							'no' 	=> esc_html__('No', 'gimont'),
						)
					));

					$wp_customize->add_setting( 'blog_single_show_share_social_icon', array(
					  'type' => 'theme_mod', // or 'option'
					  'capability' => 'edit_theme_options',
					  'theme_supports' => '', // Rarely needed.
					  'default' => 'yes',
					  'transport' => 'refresh', // or postMessage
					  'sanitize_callback' => 'sanitize_text_field' // Get function name 
					) );
					
					$wp_customize->add_control('blog_single_show_share_social_icon', array(
						'label' => esc_html__('Show Share Social Icon','gimont'),
						'section' => 'single_section',
						'settings' => 'blog_single_show_share_social_icon',
						'type' =>'select',
						'choices' => array(
							'yes' => esc_html__('Yes', 'gimont'),
							'no'  => esc_html__('No', 'gimont'),
						)
					));

					$wp_customize->add_setting( 'blog_single_show_next_prev_post', array(
					  	'type' => 'theme_mod', // or 'option'
					  	'capability' => 'edit_theme_options',
					  	'theme_supports' => '', // Rarely needed.
					  	'default' => 'yes',
					  	'transport' => 'refresh', // or postMessage
					  	'sanitize_callback' => 'sanitize_text_field' // Get function name 
					) );
					
					$wp_customize->add_control('blog_single_show_next_prev_post', array(
						'label' => esc_html__('Show Next Prev','gimont'),
						'section' => 'single_section',
						'settings' => 'blog_single_show_next_prev_post',
						'type' =>'select',
						'choices' => array(
							'yes' => esc_html__('Yes', 'gimont'),
							'no'  => esc_html__('No', 'gimont'),
						)
					));

					$wp_customize->add_setting( 'blog_single_show_leave_a_reply', array(
						'type' 				=> 'theme_mod', // or 'option'
						'capability' 		=> 'edit_theme_options',
						'theme_supports' 	=> '', // Rarely needed.
						'default' 			=> 'yes',
						'transport' 		=> 'refresh', // or postMessage
						'sanitize_callback' => 'sanitize_text_field' // Get function name 
					) );
					
					$wp_customize->add_control('blog_single_show_leave_a_reply', array(
						'label' 	=> esc_html__('Show Comment - Leave a Reply','gimont'),
						'section' 	=> 'single_section',
						'settings' 	=> 'blog_single_show_leave_a_reply',
						'type' 		=>'select',
						'choices' 	=> array(
							'yes' 	=> esc_html__('Yes', 'gimont'),
							'no' 	=> esc_html__('No', 'gimont'),
						)
					));
					
					$wp_customize->add_setting( 'single_header', array(
					  	'type' 				=> 'theme_mod', // or 'option'
					  	'capability' 			=> 'edit_theme_options',
					  	'theme_supports' 		=> '', // Rarely needed.
					  	'default' 			=> 'default',
					  	'transport' 			=> 'refresh', // or postMessage
					  	'sanitize_callback' 	=> 'sanitize_text_field' // Get function name 
					) );

					$wp_customize->add_control('single_header', array(
						'label' 	=> esc_html__('Header','gimont'),
						'section' 	=> 'single_section',
						'settings' 	=> 'single_header',
						'type' 		=> 'select',
						'choices' 	=> apply_filters( 'gimont_list_header', array() )
					));

					$wp_customize->add_setting( 'single_footer', array(
						'type' 				=> 'theme_mod', // or 'option'
						'capability' 		=> 'edit_theme_options',
						'theme_supports' 	=> '', // Rarely needed.
						'default' 			=> 'default',
						'transport' 		=> 'refresh', // or postMessage
						'sanitize_callback' => 'sanitize_text_field' // Get function name
					) );

					$wp_customize->add_control('single_footer', array(
						'label' 	=> esc_html__('Footer','gimont'),
						'section' 	=> 'single_section',
						'settings' 	=> 'single_footer',
						'type' 		=> 'select',
						'choices' 	=> apply_filters( 'gimont_list_footer', array() )
					));
	    }

	    /* Archive Donation */
	    public function gimont_init_ova_archive_donation ($wp_customize) {

			$wp_customize->add_section( 'archive_donation' , array(
				'title'      => esc_html__( 'Archive Donation', 'gimont' ),
				'priority'   => 10,
			) );

			$wp_customize->add_setting( 'archive_donation_posts_per_page', array(
			  	'type' 				=> 'theme_mod', // or 'option'
			  	'capability' 		=> 'edit_theme_options',
			  	'theme_supports' 	=> '', // Rarely needed.
			  	'default' 			=> '6',
			  	'transport' 		=> 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name
			) );
			
			$wp_customize->add_control('archive_donation_posts_per_page', array(
				'label' 	=> esc_html__('Posts Per Page','gimont'),
				'section' 	=> 'archive_donation',
				'settings' 	=> 'archive_donation_posts_per_page',
				'type' 		=>'number',
				'default' 	=> '6'
			));

			$wp_customize->add_setting( 'archive_donation_header', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'default',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 
			  
			) );

			$wp_customize->add_control('archive_donation_header', array(
				'label' => esc_html__('Header','gimont'),
				'section' => 'archive_donation',
				'settings' => 'archive_donation_header',
				'type' =>'select',
				'choices' => apply_filters('gimont_list_header', '')
			));

			$wp_customize->add_setting( 'archive_donation_footer', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'default',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 
			  
			) );

			$wp_customize->add_control('archive_donation_footer', array(
				'label' => esc_html__('Footer','gimont'),
				'section' => 'archive_donation',
				'settings' => 'archive_donation_footer',
				'type' =>'select',
				'choices' => apply_filters('gimont_list_footer', '')
			));

            $wp_customize->add_setting( 'archive_donation_column', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field', // Get function name 
				'default'  => 'three_column',
			) );

			$wp_customize->add_control('archive_donation_column', array(
				'label'    => esc_html__('Layout','gimont'),
				'section'  => 'archive_donation',
				'settings' => 'archive_donation_column',
				'type'     => 'select',
				'choices'  => array(
					'one_column' => esc_html__('1 Column', 'gimont'),
					'two_column' => esc_html__('2 Column', 'gimont'),
					'three_column' => esc_html__('3 Column', 'gimont'),
				)
			));

			$wp_customize->add_setting( 'archive_donation_show_sidebar', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field', // Get function name 
				'default'  => 'yes',
			) );

			$wp_customize->add_control('archive_donation_show_sidebar', array(
				'label'    => esc_html__('Show/Hide Sidebar','gimont'),
				'section'  => 'archive_donation',
				'settings' => 'archive_donation_show_sidebar',
				'type'     => 'select',
				'choices'  => array(
					'yes' => esc_html__('Yes', 'gimont'),
					'no' => esc_html__('No', 'gimont'),
				)
			));

			$wp_customize->add_setting( 'show_category_donation', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field', // Get function name 
				'default'  => 'yes',
			) );

			$wp_customize->add_control('show_category_donation', array(
				'label'    => esc_html__('Show/Hide Category','gimont'),
				'section'  => 'archive_donation',
				'settings' => 'show_category_donation',
				'type'     => 'select',
				'choices'  => array(
					'yes' => esc_html__('Yes', 'gimont'),
					'no' => esc_html__('No', 'gimont'),
				)
			));

			$wp_customize->add_setting( 'show_excerpt_donation', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field', // Get function name 
				'default'  => 'yes',
			) );

			$wp_customize->add_control('show_excerpt_donation', array(
				'label'    => esc_html__('Show/Hide Description','gimont'),
				'section'  => 'archive_donation',
				'settings' => 'show_excerpt_donation',
				'type'     => 'select',
				'choices'  => array(
					'yes' => esc_html__('Yes', 'gimont'),
					'no' => esc_html__('No', 'gimont'),
				)
			));

			$wp_customize->add_setting( 'number_text_donation', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => '12',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('number_text_donation', array(
				'label' => esc_html__('Number Words Description','gimont'),
				'section' => 'archive_donation',
				'settings' => 'number_text_donation',
				'type' =>'number'
			));
			
		}

		/* Single Donation */
	    public function gimont_init_ova_single_donation ($wp_customize) {

			$wp_customize->add_section( 'single_donation' , array(
				'title'      => esc_html__( 'Single Donation', 'gimont' ),
				'priority'   => 10,
			) );

			$wp_customize->add_setting( 'single_donation_header', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'default',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 
			  
			) );

			$wp_customize->add_control('single_donation_header', array(
				'label' => esc_html__('Header','gimont'),
				'section' => 'single_donation',
				'settings' => 'single_donation_header',
				'type' =>'select',
				'choices' => apply_filters('gimont_list_header', '')
			));

			$wp_customize->add_setting( 'single_donation_footer', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'default',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 
			  
			) );

			$wp_customize->add_control('single_donation_footer', array(
				'label' => esc_html__('Footer','gimont'),
				'section' => 'single_donation',
				'settings' => 'single_donation_footer',
				'type' =>'select',
				'choices' => apply_filters('gimont_list_footer', '')
			));

			$wp_customize->add_setting( 'single_donation_show_sidebar', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field', // Get function name 
				'default'  => 'yes',
			) );

			$wp_customize->add_control('single_donation_show_sidebar', array(
				'label'    => esc_html__('Show/Hide Sidebar','gimont'),
				'section'  => 'single_donation',
				'settings' => 'single_donation_show_sidebar',
				'type'     => 'select',
				'choices'  => array(
					'yes' => esc_html__('Yes', 'gimont'),
					'no' => esc_html__('No', 'gimont'),
				)
			));
			
		}

		/* Woo */
	    public function gimont_init_ova_woo( $wp_customize ){

			$wp_customize->add_setting( 'woo_archive_layout', array(
				'type'              => 'theme_mod', // or 'option'
				'capability'        => 'edit_theme_options',
				'theme_supports'    => '', // Rarely needed.
				'default'           => 'woo_layout_1c',
				'transport'         => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name   
			) );

			$wp_customize->add_control('woo_archive_layout', array(
				'label'    => esc_html__('Archive Layout','gimont'),
				'section'  => 'woocommerce_product_catalog',
				'settings' => 'woo_archive_layout',
				'type'     =>'select',
				'choices'  => array(
					'woo_layout_1c' => esc_html__('No Sidebar', 'gimont'),
					'woo_layout_2r' => esc_html__('Right Sidebar', 'gimont'),
					'woo_layout_2l' => esc_html__('Left Sidebar', 'gimont'),
				)
			));

			$wp_customize->add_setting( 'woo_sidebar_width', array(
				'type'              => 'theme_mod', // or 'option'
				'capability'        => 'edit_theme_options',
				'theme_supports'    => '', // Rarely needed.
				'default'           => '320',
				'transport'         => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('woo_sidebar_width', array(
				'label'    => esc_html__('Sidebar Width (px)','gimont'),
				'section'  => 'woocommerce_product_catalog',
				'settings' => 'woo_sidebar_width',
				'type'     =>'number'
			));

			$wp_customize->add_setting( 'woo_archive_header', array(
			  	'type' 				=> 'theme_mod', // or 'option'
			  	'capability' 		=> 'edit_theme_options',
			  	'theme_supports' 	=> '', // Rarely needed.
			  	'default' 			=> 'default',
			  	'transport' 		=> 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('woo_archive_header', array(
				'label' 	=> esc_html__('Header','gimont'),
				'section' 	=> 'woocommerce_product_catalog',
				'settings' 	=> 'woo_archive_header',
				'type' 		=>'select',
				'choices' 	=> apply_filters('gimont_list_header', '')
			));

			$wp_customize->add_setting( 'woo_archive_footer', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'default',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name
			) );

			$wp_customize->add_control('woo_archive_footer', array(
				'label' 	=> esc_html__('Footer','gimont'),
				'section' 	=> 'woocommerce_product_catalog',
				'settings' 	=> 'woo_archive_footer',
				'type' 		=>'select',
				'choices' 	=> apply_filters('gimont_list_footer', '')
			));

			/* Show/hide title in category,tag */
			$wp_customize->add_setting( 'woo_archive_show_title', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field', // Get function name 
				'default'  			=> 'yes',
			) );

	    	$wp_customize->add_control('woo_archive_show_title', array(
	    		'label'    	=> esc_html__('Show/Hide Title','gimont'),
	    		'section'  	=> 'woocommerce_product_catalog',
	    		'settings' 	=> 'woo_archive_show_title',
	    		'type'     	=> 'select',
	    		'choices'  	=> array(
	    			'yes' 	=> esc_html__('Yes', 'gimont'),
	    			'no' 	=> esc_html__('No', 'gimont'),
	    		)
	    	));

			$wp_customize->add_section( 'product_detail' , array(
			    'title' 	=> esc_html__( 'Product detail', 'gimont' ),
			    'priority' 	=> 30,
			    'panel' 	=> 'woocommerce',
			) );

			$wp_customize->add_setting( 'woo_product_layout', array(
				'type'              => 'theme_mod', // or 'option'
				'capability'        => 'edit_theme_options',
				'theme_supports'    => '', // Rarely needed.
				'default'           => 'woo_layout_1c',
				'transport'         => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );
			$wp_customize->add_control('woo_product_layout', array(
				'label'    => esc_html__('Single Layout','gimont'),
				'section'  => 'product_detail',
				'settings' => 'woo_product_layout',
				'type'     =>'select',
				'choices'  => array(
					'woo_layout_1c' => esc_html__('No Sidebar', 'gimont'),
					'woo_layout_2r' => esc_html__('Right Sidebar', 'gimont'),
					'woo_layout_2l' => esc_html__('Left Sidebar', 'gimont'),
				)
			));

			$wp_customize->add_setting( 'woo_single_header', array(
			  	'type' 				=> 'theme_mod', // or 'option'
			  	'capability' 		=> 'edit_theme_options',
			  	'theme_supports' 	=> '', // Rarely needed.
			  	'default' 			=> 'default',
			  	'transport' 		=> 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('woo_single_header', array(
				'label' 	=> esc_html__('Header','gimont'),
				'section' 	=> 'product_detail',
				'settings' 	=> 'woo_single_header',
				'type' 		=>'select',
				'choices' 	=> apply_filters('gimont_list_header', '')
			));

			$wp_customize->add_setting( 'woo_single_footer', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'default',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name
			) );

			$wp_customize->add_control('woo_single_footer', array(
				'label' 	=> esc_html__('Footer','gimont'),
				'section' 	=> 'product_detail',
				'settings' 	=> 'woo_single_footer',
				'type' 		=>'select',
				'choices' 	=> apply_filters('gimont_list_footer', '')
			));

	    	$wp_customize->add_setting( 'woo_product_detail_show_title', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field', // Get function name 
				'default'  			=> 'yes',
			) );

	    	$wp_customize->add_control('woo_product_detail_show_title', array(
	    		'label'    	=> esc_html__('Show/Hide Title','gimont'),
	    		'section'  	=> 'product_detail',
	    		'settings' 	=> 'woo_product_detail_show_title',
	    		'type'     	=> 'select',
	    		'choices'  	=> array(
	    			'yes' 	=> esc_html__('Yes', 'gimont'),
	    			'no' 	=> esc_html__('No', 'gimont'),
	    		)
	    	));
	    }
	}

}

new Gimont_Customize();