<?php if (!defined( 'ABSPATH' )) exit;

// Get current ID of post/page, etc
if( !function_exists( 'gimont_get_current_id' )):
	function gimont_get_current_id(){
	    
	    $current_page_id = '';
	    // Get The Page ID You Need
	    
	    if(class_exists("woocommerce")) {
	        if( is_shop() ){ ///|| is_product_category() || is_product_tag()) {
	            $current_page_id  =  get_option ( 'woocommerce_shop_page_id' );
	        }elseif(is_cart()) {
	            $current_page_id  =  get_option ( 'woocommerce_cart_page_id' );
	        }elseif(is_checkout()){
	            $current_page_id  =  get_option ( 'woocommerce_checkout_page_id' );
	        }elseif(is_account_page()){
	            $current_page_id  =  get_option ( 'woocommerce_myaccount_page_id' );
	        }elseif(is_view_order_page()){
	            $current_page_id  = get_option ( 'woocommerce_view_order_page_id' );
	        }
	    }
	    if($current_page_id=='') {
	        if ( is_home () && is_front_page () ) {
	            $current_page_id = '';
	        } elseif ( is_home () ) {
	            $current_page_id = get_option ( 'page_for_posts' );
	        } elseif ( is_search () || is_category () || is_tag () || is_tax () || is_archive() ) {
	            $current_page_id = '';
	        } elseif ( !is_404 () ) {
	           $current_page_id = get_the_id();
	        } 
	    }

	    return $current_page_id;
	}
endif;

if( !function_exists( 'gimont_give_pagination_theme' )):
function gimont_give_pagination_theme() {
           
    if( is_singular() )
        return;
 
    global $wp_query;
 
    /** Stop execution if there's only 1 page */
    if( $wp_query->max_num_pages <= 1 )
        return;
 
    $paged = get_query_var( 'paged' ) ? absint( get_query_var( 'paged' ) ) : 1;
    $max   = intval( $wp_query->max_num_pages );
 
    /** Add current page to the array */
    if ( $paged >= 1 )
        $links[] = $paged;
 
    /** Add the pages around the current page to the array */
    if ( $paged >= 3 ) {
        $links[] = $paged - 1;
        $links[] = $paged - 2;
    }
 
    if ( ( $paged + 2 ) <= $max ) {
        $links[] = $paged + 2;
        $links[] = $paged + 1;
    }
 
    echo wp_kses( __( '<div class="give_pagination"><ul class="pagination">','gimont' ), true ) . "\n";
 
    /** Previous Post Link */
    if ( get_previous_posts_link() )
        printf( '<li class="prev page-numbers">%s</li>' . "\n",  get_previous_posts_link(sprintf('<i class="ovaicon ovaicon-back"></i>%s', '' )) );
 
    /** Link to first page, plus ellipses if necessary */
    if ( ! in_array( 1, $links ) ) {
        $class = 1 == $paged ? ' class="active"' : '';
 
        printf( '<li%s><a href="%s">%s</a></li>' . "\n", $class, esc_url( get_pagenum_link( 1 ) ), '1' );
 
        if ( ! in_array( 2, $links ) )
            echo wp_kses( __('<li><span class="pagi_dots">...</span></li>', 'gimont' ) , true);
    }
 
    /** Link to current page, plus 2 pages in either direction if necessary */
    sort( $links );
    foreach ( (array) $links as $link ) {
        $class = $paged == $link ? ' class="active"' : '';
        printf( '<li%s><a href="%s">%s</a></li>' . "\n", $class, esc_url( get_pagenum_link( $link ) ), $link );
    }
 
    /** Link to last page, plus ellipses if necessary */
    if ( ! in_array( $max, $links ) ) {
        if ( ! in_array( $max - 1, $links ) )
            echo wp_kses( __('<li><span class="pagi_dots">...</span></li>', 'gimont' ) , true) . "\n";
 
        $class = $paged == $max ? ' class="active"' : '';
        printf( '<li%s><a href="%s">%s</a></li>' . "\n", $class, esc_url( get_pagenum_link( $max ) ), $max );
    }
 
    /** Next Post Link */
    if ( get_next_posts_link() )
        printf( '<li class="next page-numbers">%s</li>' . "\n", get_next_posts_link( sprintf('%s <i class="ovaicon ovaicon-next"></i>', '' )) );
 
    echo wp_kses( __( '</ul></div>', 'gimont' ), true ) . "\n";
 
}
endif;

if (!function_exists('gimont_is_elementor_active')) {
    function gimont_is_elementor_active(){
        return did_action( 'elementor/loaded' );
    }
}

if (!function_exists('gimont_is_woo_active')) {
    function gimont_is_woo_active(){
        return class_exists('woocommerce');    
    }
}

if (!function_exists('gimont_is_blog_archive')) {
    function gimont_is_blog_archive() {
        return (is_home() && is_front_page()) || is_archive() || is_category() || is_tag() || is_home();
    }
}

if (!function_exists('gimont_is_woo_archive')) {
    function gimont_is_woo_archive() {
        return is_post_type_archive('product') || is_tax('product_cat') || is_tax('product_tag');
    }
}

if (!function_exists('gimont_is_give_archive')) {
    function gimont_is_give_archive() {
        return is_post_type_archive('give_forms') || is_tax('give_forms_category') || is_tax('give_forms_tag');
    }
}



/* Get ID from Slug of Header Footer Builder - Post Type */
function gimont_get_id_by_slug( $page_slug ) {
    $page = get_page_by_path( $page_slug, OBJECT, 'ova_framework_hf_el' ) ;
    if ($page) {
        return $page->ID;
    } else {
        return null;
    }
}


function gimont_custom_text($content = "",$limit = 15) {

    $content = explode(' ', $content, $limit);

    if (count($content)>=$limit) {
        array_pop($content);
        $content = implode(" ",$content).'...';
    } else {
        $content = implode(" ",$content);
    }

    $content = preg_replace('`[[^]]*]`','',$content);
    
    return strip_tags( $content );
}

/* sanitize array */
function gimont_array_sanitize_text_field( $array ) {
    foreach ( $array as $key => &$value ) {
        if ( is_array( $value ) ) {
            $value = gimont_array_sanitize_text_field( $value );
        } else {
            $value = sanitize_text_field( $value );
        }
    }
    return $array;
}


/**
 * Google Font sanitization
 *
 * @param  string   JSON string to be sanitized
 * @return string   Sanitized input
 */
if ( ! function_exists( 'gimont_google_font_sanitization' ) ) {
    function gimont_google_font_sanitization( $input ) {
        $val =  json_decode( $input, true );
        if( is_array( $val ) ) {
            foreach ( $val as $key => $value ) {
                $val[$key] = sanitize_text_field( $value );
            }
            $input = json_encode( $val );
        }
        else {
            $input = json_encode( sanitize_text_field( $val ) );
        }
        return $input;
    }
}

/* Default Primary Color in Customize */
if ( ! function_exists( 'gimont_default_primary_color' ) ) {
    function gimont_default_primary_color() {
        $primary_color = get_theme_mod( 'primary_color', '#D82221' );

        return $primary_color;
    }
}

/* Default Primary Font in Customize */
if ( ! function_exists( 'gimont_default_primary_font' ) ) {
    function gimont_default_primary_font() {
        $customizer_defaults = json_encode(
            array(
                'font' => 'Manrope',
                'regularweight' => '200,300,regular,500,600,700,800',
                'category' => 'serif'
            )
        );

        return $customizer_defaults;
    }
}

/* Default Second Font in Customize */
if ( ! function_exists( 'gimont_default_second_font' ) ) {
    function gimont_default_second_font() {
        $customizer_defaults = json_encode(
            array(
                'font' => 'Raleway',
                'regularweight' => '100,200,300,400,500,600,700,800,900',
                'category' => 'serif'
            )
        );

        return $customizer_defaults;
    }
}

if ( ! function_exists( 'gimont_woo_sidebar' ) ) {
    function gimont_woo_sidebar(){
        if( class_exists('woocommerce') && is_product() ){
            return get_theme_mod( 'woo_product_layout', 'woo_layout_1c' );
        }else{
            return get_theme_mod( 'woo_archive_layout', 'woo_layout_1c' );
        }
    }
}

if( !function_exists( 'gimont_blog_show_media' ) ){
    function gimont_blog_show_media(){
        $show_media = get_theme_mod( 'blog_archive_show_media', 'yes' );
        return isset( $_GET['show_media'] ) ? $_GET['show_media'] : $show_media;
    }
}

if( !function_exists( 'gimont_blog_show_title' ) ){
    function gimont_blog_show_title(){
        $show_title = get_theme_mod( 'blog_archive_show_title', 'yes' );
        return isset( $_GET['show_title'] ) ? $_GET['show_title'] : $show_title;
    }
}

if( !function_exists( 'gimont_blog_show_date' ) ){
    function gimont_blog_show_date(){
        $show_date = get_theme_mod( 'blog_archive_show_date', 'yes' );
        return isset( $_GET['show_date'] ) ? $_GET['show_date'] : $show_date;
    }
}

if( !function_exists( 'gimont_blog_show_cat' ) ){
    function gimont_blog_show_cat(){
        $show_cat = get_theme_mod( 'blog_archive_show_cat', 'yes' );
        return isset( $_GET['show_cat'] ) ? $_GET['show_cat'] : $show_cat;
    }
}

if( !function_exists( 'gimont_blog_show_author' ) ){
    function gimont_blog_show_author(){
        $show_author = get_theme_mod( 'blog_archive_show_author', 'yes' );
        return isset( $_GET['show_author'] ) ? $_GET['show_author'] : $show_author;
    }
}

if( !function_exists( 'gimont_blog_show_comment' ) ){
    function gimont_blog_show_comment(){
        $show_comment = get_theme_mod( 'blog_archive_show_comment', 'yes' );
        return isset( $_GET['show_comment'] ) ? $_GET['show_comment'] : $show_comment;
    }
}

if( !function_exists( 'gimont_blog_show_excerpt' ) ){
    function gimont_blog_show_excerpt(){
        $show_excerpt = get_theme_mod( 'blog_archive_show_excerpt', 'yes' );
        return isset( $_GET['show_excerpt'] ) ? $_GET['show_excerpt'] : $show_excerpt;
    }
}


if( !function_exists( 'gimont_blog_show_readmore' ) ){
    function gimont_blog_show_readmore(){
        $show_readmore = get_theme_mod( 'blog_archive_show_readmore', 'yes' );
        return isset( $_GET['show_readmore'] ) ? $_GET['show_readmore'] : $show_readmore;
    }
}



if( !function_exists( 'gimont_post_show_media' ) ){
    function gimont_post_show_media(){
        $show_media = get_theme_mod( 'blog_single_show_media', 'yes' );
        return isset( $_GET['show_media'] ) ? $_GET['show_media'] : $show_media;
    }
}

if( !function_exists( 'gimont_post_show_title' ) ){
    function gimont_post_show_title(){
        $show_title = get_theme_mod( 'blog_single_show_title', 'yes' );
        return isset( $_GET['show_title'] ) ? $_GET['show_title'] : $show_title;
    }
}

if( !function_exists( 'gimont_post_show_date' ) ){
    function gimont_post_show_date(){
        $show_date = get_theme_mod( 'blog_single_show_date', 'yes' );
        return isset( $_GET['show_date'] ) ? $_GET['show_date'] : $show_date;
    }
}

if( !function_exists( 'gimont_post_show_cat' ) ){
    function gimont_post_show_cat(){
        $show_cat = get_theme_mod( 'blog_single_show_cat', 'yes' );
        return isset( $_GET['show_cat'] ) ? $_GET['show_cat'] : $show_cat;
    }
}

if( !function_exists( 'gimont_post_show_author' ) ){
    function gimont_post_show_author(){
        $show_author = get_theme_mod( 'blog_single_show_author', 'yes' );
        return isset( $_GET['show_author'] ) ? $_GET['show_author'] : $show_author;
    }
}

if( !function_exists( 'gimont_post_show_comment' ) ){
    function gimont_post_show_comment(){
        $show_comment = get_theme_mod( 'blog_single_show_comment', 'yes' );
        return isset( $_GET['show_comment'] ) ? $_GET['show_comment'] : $show_comment;
    }
}

if( !function_exists( 'gimont_post_show_content' ) ){
    function gimont_post_show_content(){
        $show_content = get_theme_mod( 'blog_single_show_content', 'yes' );
        return isset( $_GET['show_content'] ) ? $_GET['show_content'] : $show_content;
    }
}

if( !function_exists( 'gimont_post_show_tag' ) ){
    function gimont_post_show_tag(){
        $show_tag = get_theme_mod( 'blog_single_show_tag', 'yes' );
        return isset( $_GET['show_tag'] ) ? $_GET['show_tag'] : $show_tag;
    }
}

if( !function_exists( 'gimont_post_show_share_social_icon' ) ){
    function gimont_post_show_share_social_icon(){
        $show_share_social_icon = get_theme_mod( 'blog_single_show_share_social_icon', 'yes' );
        return isset( $_GET['show_share_social_icon'] ) ? $_GET['show_share_social_icon'] : $show_share_social_icon;
    }
}

if( !function_exists( 'gimont_post_show_next_prev_post' ) ){
    function gimont_post_show_next_prev_post(){
        $show_next_prev_post = get_theme_mod( 'blog_single_show_next_prev_post', 'yes' );
        return isset( $_GET['show_next_prev_post'] ) ? $_GET['show_next_prev_post'] : $show_next_prev_post;
    }
}

if( !function_exists( 'gimont_post_show_leave_a_reply' ) ){
    function gimont_post_show_leave_a_reply(){
        $show_leave_a_reply = get_theme_mod( 'blog_single_show_leave_a_reply', 'yes' );
        return isset( $_GET['show_leave_a_reply'] ) ? $_GET['show_leave_a_reply'] : $show_leave_a_reply;
    }
}